/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.pojodb;

import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.JdbcConnectionPool;
import eu.javaexperience.database.JdbcIssuedConnection;
import eu.javaexperience.database.pojodb.Database;
import eu.javaexperience.database.pojodb.Model;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

public class SqlDatabase
implements Database {
    protected ConnectionCreator cc;
    protected JdbcConnectionPool pool;

    public SqlDatabase(ConnectionCreator cc) {
        this.cc = cc;
        this.pool = new JdbcConnectionPool(cc);
    }

    @Override
    public <T extends Model> T getInstanceById(Class<T> cls, Object id) throws SQLException, InstantiationException, IllegalAccessException {
        return this.getInstance(cls, "id", id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Model> T getInstance(Class<T> cls, String field, Object id) throws SQLException, InstantiationException, IllegalAccessException {
        Model ret = (Model)cls.newInstance();
        try (JdbcIssuedConnection conn = this.pool.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT * FROM `" + ret.getTable() + "` WHERE `" + field + "`= ?");){
            ps.setObject(1, id);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                T t = null;
                return t;
            }
            JDBC.simpleReadIntoJavaObject(rs, ret.getFields(), ret);
            return (T)ret;
        }
    }

    public JdbcConnectionPool getPool() {
        return this.pool;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.pool.getConnection();
    }

    @Override
    public void insert(Model m) throws SQLException {
        try (JdbcIssuedConnection conn = this.pool.getConnection();){
            try {
                JDBC.simpleInsertIntoTableFromJavaObject(conn, m.getFields(), m.getTable(), m, m.getIdField());
            }
            catch (Exception e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
    }

    public static Field whereFieldName(Field[] sqlFields, String name) {
        for (Field f : sqlFields) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    @Override
    public void updateById(Model m) throws SQLException {
        try (JdbcIssuedConnection conn = this.pool.getConnection();){
            try {
                JDBC.simpleUpdateTableFromJavaObject(conn, m.getFields(), m.getTable(), m, m.getIdField().getName() + " =? ", m.getIdField().get(m));
            }
            catch (Exception e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
    }

    @Override
    public void delete(Model m) throws SQLException {
        try (JdbcIssuedConnection conn = this.pool.getConnection();){
            try {
                JDBC.executePrepared(conn, "DELETE FROM `" + m.getTable() + "` WHERE `" + m.getIdField().getName() + "` = ? ", m.getIdField().get(m));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
    }

    public <T extends Model> int getAllInstance(Class<T> cls, Collection<T> dst) throws InstantiationException, IllegalAccessException, SQLException {
        int nums = 0;
        Model ret = (Model)cls.newInstance();
        try (JdbcIssuedConnection conn = this.pool.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT * FROM `" + ret.getTable() + "`");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ret = (Model)cls.newInstance();
                JDBC.simpleReadIntoJavaObject(rs, ret.getFields(), ret);
                dst.add(ret);
                ++nums;
            }
        }
        return nums;
    }
}

