/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.io.IOTools;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class IpAddressTools {
    protected static final Pattern NAIVE_IP_MATCH = Pattern.compile("^(\\d{1,3}\\.){3,3}\\d{1,3}$");
    protected static final String[] RAW_IP_PROBES_URLS = new String[]{"http://checkip.amazonaws.com/", "http://myexternalip.com/raw", "http://icanhazip.com/", "http://www.trackip.net/ip", "http://ipecho.net/plain", "http://bot.whatismyipaddress.com/"};

    public static int parseIPv4AsInt(String line) {
        int d1 = -1;
        int d2 = -1;
        int d3 = -1;
        d1 = line.indexOf(46, 1);
        if (-1 == d1) {
            return -1;
        }
        d2 = line.indexOf(46, d1 + 2);
        if (-1 == d2) {
            return -1;
        }
        d3 = line.indexOf(46, d2 + 2);
        if (-1 == d3) {
            return -1;
        }
        int start = -1;
        int tmp = 0;
        int i = d1 - 1;
        while (i >= 0 && i >= d1 - 3 && (tmp = line.charAt(i) - 48) >= 0 && tmp < 10) {
            start = i--;
        }
        if (-1 == start) {
            return -1;
        }
        int ip = 0;
        tmp = IpAddressTools.parseIpv4Int(line, start);
        if (-1 == tmp) {
            return -1;
        }
        ip |= tmp << 24;
        tmp = IpAddressTools.parseIpv4Int(line, d1 + 1);
        if (-1 == tmp) {
            return -1;
        }
        ip |= tmp << 16;
        tmp = IpAddressTools.parseIpv4Int(line, d2 + 1);
        if (-1 == tmp) {
            return -1;
        }
        ip |= tmp << 8;
        tmp = IpAddressTools.parseIpv4Int(line, d3 + 1);
        if (-1 == tmp) {
            return -1;
        }
        return ip |= tmp;
    }

    protected static int parseIpv4Int(String str, int index) {
        int ret = 0;
        int tmp = 0;
        int end = index + 3;
        if (str.length() < end) {
            end = str.length();
        }
        for (int i = index; i < end; ++i) {
            tmp = str.charAt(i) - 48;
            if (tmp < 0 || tmp > 9) {
                if (index == i) {
                    return -1;
                }
                return ret;
            }
            ret *= 10;
            ret += tmp;
        }
        return ret;
    }

    public static void fillIpv4(int ip, short[] address) {
        address[0] = (short)(ip >> 24 & 0xFF);
        address[1] = (short)(ip >> 16 & 0xFF);
        address[2] = (short)(ip >> 8 & 0xFF);
        address[3] = (short)(ip & 0xFF);
    }

    public static String getIpAddress(int ip) {
        short[] addr = new short[4];
        IpAddressTools.fillIpv4(ip, addr);
        return addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3];
    }

    protected static void test(String line) {
        int ip = IpAddressTools.parseIPv4AsInt(line);
        short[] nums = new short[4];
        IpAddressTools.fillIpv4(ip, nums);
        System.out.println("IPv4: " + nums[0] + "." + nums[1] + "." + nums[2] + "." + nums[3]);
    }

    public static List<InetAddress> getHostIpAddresses() throws SocketException {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                addrs.add(ee.nextElement());
            }
        }
        return addrs;
    }

    public static boolean isIpv4(String str) {
        return NAIVE_IP_MATCH.matcher(str).find();
    }

    public static String getPublicIp() {
        for (String s : RAW_IP_PROBES_URLS) {
            try {
                URL u = new URL(s);
                URLConnection conn = u.openConnection();
                String str = new String(IOTools.loadAllFromInputStream(conn.getInputStream()));
                str = str.trim();
                if (!IpAddressTools.isIpv4(str)) continue;
                return str;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "127.0.0.1";
    }

    public static void main(String[] args) throws Throwable {
        for (InetAddress addr : IpAddressTools.getHostIpAddresses()) {
            if (!(addr instanceof Inet4Address)) continue;
            System.out.println(addr.getHostAddress());
        }
    }

    public static boolean isReachable(InetAddress addr, int timeout) throws IOException {
        return addr.isReachable(timeout);
    }

    public static boolean isReachable(String addr, int timeout) throws IOException {
        return InetAddress.getByName(addr).isReachable(timeout);
    }
}

