/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.log;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.log.ExtraLogLevel;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.log.RotaLogOutput;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.time.TimeCalc;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CasualLogOutput
extends RotaLogOutput {
    protected final String logPrefix;
    protected final SimpleGet<Logger> newDayAllLoglevelWriter;
    protected long nextCutTime = this.getNextCutDate();

    public CasualLogOutput(String logPrefix, @MayNull SimpleGet<Logger> newDayAllLoglevelWriter) {
        this.logPrefix = logPrefix;
        this.newDayAllLoglevelWriter = newDayAllLoglevelWriter;
    }

    @Override
    protected File getNextLogfile() {
        String s = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        return new File(this.logPrefix + s + ".log");
    }

    public long getNextCutDate() {
        return TimeCalc.addToDate(TimeCalc.setToDate(new Date(), -1, -1, -1, 0, 0, 0, 0), 0, 0, 1, 0, 0, 0, 0).getTime() + 1000L;
    }

    @Override
    protected boolean needCut() {
        if (System.currentTimeMillis() >= this.nextCutTime) {
            this.nextCutTime = this.getNextCutDate();
            return true;
        }
        return false;
    }

    @Override
    protected void afterOpenNewUnit() {
        Logger LOG;
        if (null != this.newDayAllLoglevelWriter && null != (LOG = this.newDayAllLoglevelWriter.get())) {
            ArrayList<Logger> loggers = new ArrayList<Logger>();
            JavaExperienceLoggingFacility.listIssuedLoggers(loggers);
            LoggingTools.tryLogSimple(LOG, (LoggingDetailLevel)ExtraLogLevel.MANDATORY, "New day, new log file");
            for (Logger l : loggers) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)ExtraLogLevel.MANDATORY, "Loglevel of %s is %s", (Object)l, (Object)l.getLogLevel().getLabel());
            }
        }
    }
}

