/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.multithread.BlockingJob;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ScalableThreadpool<T> {
    protected final SimpleGet<BlockingJob<T>> blockingJobFactory;
    protected Vector<Thread> workers = new Vector();
    protected AtomicInteger numberOfWorkers = new AtomicInteger();
    protected AtomicInteger waitingWorkers = new AtomicInteger();
    protected AtomicInteger workingWorkers = new AtomicInteger();
    protected final AtomicReference<Semaphore> semaphoreForShrink = new AtomicReference();
    protected boolean alive = true;

    public ScalableThreadpool(SimpleGet<BlockingJob<T>> blockingJobFactory) {
        this.blockingJobFactory = blockingJobFactory;
        AssertArgument.assertNotNull(this.blockingJobFactory, "blockingJobFactory");
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers.get();
    }

    public void setNumberOfWorkers(int initialWorkerCount) {
        this.numberOfWorkers.set(initialWorkerCount);
    }

    public int getNumberOfWaitingWorkers() {
        return this.waitingWorkers.get();
    }

    public int getNumberOfWorkingWorkers() {
        return this.workingWorkers.get();
    }

    public synchronized void setWorkerCount(int newCount) throws InterruptedException {
        int current = this.numberOfWorkers.get();
        this.numberOfWorkers.set(newCount);
        if (current == newCount) {
            return;
        }
        if (newCount <= 0) {
            this.cleanShutdown();
            return;
        }
        if (newCount < current) {
            this.shrinkWorkers();
            return;
        }
        if (newCount <= current) {
            System.out.println("Impossible: newCount:" + newCount + " current: " + current);
            return;
        }
        this.growthWorkers();
    }

    protected synchronized void shrinkWorkers() {
        Semaphore sem = new Semaphore(this.numberOfWorkers.get());
        this.semaphoreForShrink.set(sem);
        this.semaphoreForShrink.set(null);
    }

    protected synchronized void growthWorkers() {
        int plus = this.numberOfWorkers.get() - this.workers.size();
        for (int i = 0; i < plus; ++i) {
            Thread t = this.createNewWorker();
            this.workers.add(t);
            t.start();
        }
    }

    public synchronized void start() {
        this.growthWorkers();
    }

    public synchronized void cleanShutdown() {
        this.numberOfWorkers.set(0);
        this.shrinkWorkers();
    }

    protected Thread createNewWorker() {
        return new Thread(){
            protected final BlockingJob<T> job;
            {
                this.job = ScalableThreadpool.this.blockingJobFactory.get();
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    @Deprecated
    public void fillThreads(Collection<Thread> poolThreads) {
        poolThreads.addAll(this.workers);
    }

    public void stop() {
        this.alive = false;
        this.cleanShutdown();
        for (Thread t : this.workers) {
            t.interrupt();
        }
    }
}

