/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.query;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.F;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import java.util.Collection;
import java.util.regex.Pattern;

public class QueryEvaluatorBuilder<T> {
    public GetBy2<Object, T, String> extractor = Mirror::tryGetFieldValue;
    public GetBy2<Boolean, Object, Object> equals = Mirror::equals;
    public GetBy2<Boolean, Object, Object> contains = new GetBy2<Boolean, Object, Object>(){

        @Override
        public Boolean getBy(Object a, Object b) {
            return QueryEvaluatorBuilder.processPossibleCollections(a, b, true, (x, y) -> x.toString().contains(y.toString()));
        }
    };
    public GetBy2<Integer, Object, Object> compare = new GetBy2<Integer, Object, Object>(){

        @Override
        public Integer getBy(Object a, Object b) {
            if (null == a || null == b) {
                return null;
            }
            if (a.getClass() != b.getClass()) {
                if (a instanceof String) {
                    b = b.toString();
                } else if (b instanceof Number) {
                    b = CastTo.getCasterForTargetClass(a.getClass()).cast(b);
                }
            }
            if (a.getClass() == b.getClass() && a instanceof Comparable) {
                return ((Comparable)b).compareTo(a);
            }
            return null;
        }
    };
    public GetBy2<Boolean, Object, Object> in = new GetBy2<Boolean, Object, Object>(){

        @Override
        public Boolean getBy(Object a, Object b) {
            return QueryEvaluatorBuilder.processPossibleCollections(a, b, false, Mirror::equals);
        }
    };
    public GetBy2<Boolean, Object, Object> match = new GetBy2<Boolean, Object, Object>(){

        @Override
        public Boolean getBy(Object a, Object b) {
            return QueryEvaluatorBuilder.processPossibleCollections(a, b, true, (x, y) -> {
                Pattern p = null;
                p = a instanceof Pattern ? (Pattern)x : Pattern.compile(x.toString());
                return p.matcher(y.toString()).matches();
            });
        }
    };

    protected static Boolean processPossibleCollections(Object expected, Object actual, boolean restrictToAll_or_consessiveToAll, GetBy2<Boolean, Object, Object> op) {
        if (null == actual || null == expected) {
            return null;
        }
        if (actual instanceof Collection) {
            Collection ca = (Collection)actual;
            if (expected instanceof Collection) {
                Collection ce = (Collection)expected;
                if (ca.isEmpty() && ce.isEmpty()) {
                    return false;
                }
                boolean hasPassing = false;
                for (Object a : ca) {
                    for (Object e : ce) {
                        Boolean eq = op.getBy(e, a);
                        if (restrictToAll_or_consessiveToAll && Boolean.TRUE != eq) {
                            return false;
                        }
                        if (Boolean.TRUE == eq) {
                            if (!restrictToAll_or_consessiveToAll) {
                                return true;
                            }
                            hasPassing = true;
                            continue;
                        }
                        if (!restrictToAll_or_consessiveToAll) continue;
                        return false;
                    }
                }
                return hasPassing;
            }
            boolean hasPassing = false;
            for (Object e : ca) {
                Boolean eq = op.getBy(e, actual);
                if (restrictToAll_or_consessiveToAll && Boolean.TRUE != eq) {
                    return false;
                }
                if (Boolean.TRUE == eq) {
                    if (!restrictToAll_or_consessiveToAll) {
                        return true;
                    }
                    hasPassing = true;
                    continue;
                }
                if (!restrictToAll_or_consessiveToAll) continue;
                return false;
            }
            return hasPassing;
        }
        if (expected instanceof Collection) {
            boolean hasPassing = false;
            Collection ce = (Collection)expected;
            for (Object e : ce) {
                Boolean eq = op.getBy(e, actual);
                if (restrictToAll_or_consessiveToAll && Boolean.TRUE != eq) {
                    return false;
                }
                if (Boolean.TRUE == eq) {
                    if (!restrictToAll_or_consessiveToAll) {
                        return true;
                    }
                    hasPassing = true;
                    continue;
                }
                if (!restrictToAll_or_consessiveToAll) continue;
                return false;
            }
            return hasPassing;
        }
        return op.getBy(expected, actual);
    }

    protected static Boolean tryCmp(boolean gt_lt, boolean eq, Integer val) {
        if (null == val) {
            return null;
        }
        if (eq && PrimitiveTools.INT_ZERO.equals(val)) {
            return true;
        }
        if (gt_lt) {
            return val > 0;
        }
        return val < 0;
    }

    public GetBy2<Boolean, T, AtomicCondition> build() {
        return new GetBy2<Boolean, T, AtomicCondition>(){

            @Override
            public Boolean getBy(T a, AtomicCondition b) {
                F op = b.getOperator();
                Object expected = b.getValue();
                Object actual = QueryEvaluatorBuilder.this.extractor.getBy(a, b.getFieldName());
                Boolean eval = null;
                switch (op) {
                    case contains: {
                        eval = QueryEvaluatorBuilder.this.contains.getBy(expected, actual);
                        break;
                    }
                    case eq: {
                        eval = QueryEvaluatorBuilder.this.equals.getBy(expected, actual);
                        break;
                    }
                    case gt: {
                        eval = QueryEvaluatorBuilder.tryCmp(true, false, QueryEvaluatorBuilder.this.compare.getBy(expected, actual));
                        break;
                    }
                    case gte: {
                        eval = QueryEvaluatorBuilder.tryCmp(true, true, QueryEvaluatorBuilder.this.compare.getBy(expected, actual));
                        break;
                    }
                    case lt: {
                        eval = QueryEvaluatorBuilder.tryCmp(false, false, QueryEvaluatorBuilder.this.compare.getBy(expected, actual));
                        break;
                    }
                    case lte: {
                        eval = QueryEvaluatorBuilder.tryCmp(false, true, QueryEvaluatorBuilder.this.compare.getBy(expected, actual));
                        break;
                    }
                    case in: {
                        eval = QueryEvaluatorBuilder.this.in.getBy(expected, actual);
                        break;
                    }
                    case match: {
                        eval = QueryEvaluatorBuilder.this.match.getBy(expected, actual);
                        break;
                    }
                    default: {
                        throw new UnimplementedCaseException(op);
                    }
                }
                if (null == eval) {
                    return false;
                }
                return b.isNegated() != eval.booleanValue();
            }
        };
    }
}

