/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.reflect;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.NotatedCaster;
import eu.javaexperience.text.Format;
import java.sql.Date;
import java.util.IdentityHashMap;
import java.util.Map;

public enum CastTo implements NotatedCaster
{
    Boolean("boolean"){

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Boolean) {
                return o;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue() != 0L;
            }
            String str = ((String)String.cast(o)).toLowerCase();
            try {
                return java.lang.Double.parseDouble(str) != 0.0;
            }
            catch (Exception exception) {
                boolean tr = str.contains("true");
                boolean fa = str.contains("false");
                if (tr != fa) {
                    return tr;
                }
                if (str.length() < 2 && (tr = str.contains("t")) != (fa = str.contains("f"))) {
                    return tr;
                }
                return null;
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Boolean.class.isAssignableFrom(cls) || java.lang.Boolean.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Boolean.class, java.lang.Boolean.TYPE};
        }
    }
    ,
    Byte("byte"){
        private final Byte zero = 0;
        private final Byte one = 1;

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return ((Number)o).byteValue();
            }
            if (o instanceof Character) {
                return (byte)((Character)o).charValue();
            }
            if (o instanceof Boolean) {
                return (byte)(o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero);
            }
            String str = o.toString().trim();
            try {
                return (byte)java.lang.Long.parseLong(str);
            }
            catch (Exception exception) {
                try {
                    return (byte)java.lang.Double.parseDouble(str);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Byte.class.isAssignableFrom(cls) || java.lang.Byte.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Byte.class, java.lang.Byte.TYPE};
        }
    }
    ,
    Char("char"){
        private final Character forTrue = Character.valueOf('t');
        private final Character forFalse = Character.valueOf('\u0000');

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return Character.valueOf((char)((Number)o).longValue());
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.forTrue : this.forFalse;
            }
            String str = o.toString();
            if (str.length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            if ((str = str.trim()).length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            try {
                return Character.valueOf((char)java.lang.Long.parseLong(str));
            }
            catch (Exception exception) {
                try {
                    return Character.valueOf((char)java.lang.Double.parseDouble(str));
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Character.class.isAssignableFrom(cls) || Character.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Character.class, Character.TYPE};
        }
    }
    ,
    Short("short"){
        private final Short zero = 0;
        private final Short one = 1;

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            if (o instanceof Character) {
                return (short)((Character)o).charValue();
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero;
            }
            String str = o.toString();
            try {
                return (short)java.lang.Long.parseLong(str);
            }
            catch (Exception exception) {
                try {
                    return (short)java.lang.Double.parseDouble(str);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Short.class.isAssignableFrom(cls) || java.lang.Short.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Short.class, java.lang.Short.TYPE};
        }
    }
    ,
    Int("int"){
        private final Integer zero = 0;
        private final Integer one = 1;

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof Character) {
                return (int)((Character)o).charValue();
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero;
            }
            String str = ((String)String.cast(o)).trim();
            try {
                return (int)java.lang.Long.parseLong(str);
            }
            catch (Exception exception) {
                try {
                    return (int)java.lang.Double.parseDouble(str);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Integer.class, Integer.TYPE};
        }
    }
    ,
    Long("long"){
        private final Long zero = 0L;
        private final Long one = 1L;

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            if (o instanceof Character) {
                return (long)((Character)o).charValue();
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero;
            }
            String str = o.toString().trim();
            try {
                return java.lang.Long.parseLong(str);
            }
            catch (Exception exception) {
                try {
                    return (long)java.lang.Double.parseDouble(str);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Long.class.isAssignableFrom(cls) || java.lang.Long.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Long.class, java.lang.Long.TYPE};
        }
    }
    ,
    Float("float"){
        private final Float zero = java.lang.Float.valueOf(0.0f);
        private final Float one = java.lang.Float.valueOf(1.0f);

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return java.lang.Float.valueOf(((Number)o).floatValue());
            }
            if (o instanceof Character) {
                return java.lang.Float.valueOf(((Character)o).charValue());
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero;
            }
            String str = o.toString().trim();
            try {
                return java.lang.Float.valueOf(java.lang.Float.parseFloat(str));
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Float.class.isAssignableFrom(cls) || java.lang.Float.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Float.class, java.lang.Float.TYPE};
        }
    }
    ,
    Double("double"){
        private final Double zero = 0.0;
        private final Double one = 1.0;

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof Character) {
                return (double)((Character)o).charValue();
            }
            if (o instanceof Boolean) {
                return o.equals(java.lang.Boolean.TRUE) ? this.one : this.zero;
            }
            String str = o.toString().trim();
            try {
                return java.lang.Double.parseDouble(str);
            }
            catch (Exception exception) {
                try {
                    return java.lang.Double.parseDouble(str.replace(',', '.'));
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return Double.class.isAssignableFrom(cls) || java.lang.Double.TYPE.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{Double.class, java.lang.Double.TYPE};
        }
    }
    ,
    String("String", "java.lang.String"){

        @Override
        public Object cast(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof byte[]) {
                return new String((byte[])o);
            }
            return o.toString();
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return String.class.isAssignableFrom(cls) || CharSequence.class.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{String.class, CharSequence.class, StringBuilder.class, StringBuffer.class};
        }
    }
    ,
    Date("Date", "java.util.Date"){

        @Override
        public Object cast(Object o) {
            if (null == o) {
                return null;
            }
            if (o instanceof java.util.Date) {
                return o;
            }
            String str = o.toString();
            java.util.Date d = Format.strtotime.strtotime(str);
            if (null != d) {
                return d;
            }
            Object time = Long.cast(str);
            if (time instanceof Number) {
                return new java.util.Date(((Number)time).longValue());
            }
            return null;
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return java.util.Date.class.isAssignableFrom(cls);
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[]{java.util.Date.class, Date.class};
        }
    }
    ,
    Object("Object", "java.lang.Object"){

        @Override
        public Object cast(Object o) {
            return o;
        }

        @Override
        public boolean canAssignForType(Class<?> cls) {
            return true;
        }

        @Override
        public Class[] getAssignTypes() {
            return new Class[0];
        }
    };

    protected final String shortName;
    protected final String fullQualname;
    protected final GetBy1<Object, Object> converter = new GetBy1<Object, Object>(){

        @Override
        public Object getBy(Object a) {
            return CastTo.this.cast(a);
        }
    };
    private static final CastTo[] whitoutObject;
    protected static Map<Class, CastTo> typeToCaster;

    private CastTo(String name) {
        this.shortName = this.fullQualname = name;
    }

    private CastTo(String shortName, String longName) {
        this.shortName = shortName;
        this.fullQualname = longName;
    }

    @Override
    public String getTypeShortName() {
        return this.shortName;
    }

    @Override
    public String getTypeFullQualifiedName() {
        return this.fullQualname;
    }

    @Override
    public abstract Object cast(Object var1);

    public abstract Class[] getAssignTypes();

    public abstract boolean canAssignForType(Class<?> var1);

    public static CastTo getCasterRestrictlyForTargetClass(Class<?> cls) {
        if (Object.class == cls) {
            return Object;
        }
        return typeToCaster.get(cls);
    }

    public static CastTo getCasterForTargetClass(Class<?> cls) {
        CastTo ret = typeToCaster.get(cls);
        if (null != ret) {
            return ret;
        }
        return Object;
    }

    static {
        whitoutObject = new CastTo[CastTo.values().length - 1];
        int ep = 0;
        CastTo[] castToArray = CastTo.values();
        int n = castToArray.length;
        for (int i = 0; i < n; ++i) {
            CastTo t = castToArray[i];
            if (t == Object) continue;
            CastTo.whitoutObject[ep++] = t;
        }
        typeToCaster = new IdentityHashMap<Class, CastTo>();
        for (CastTo t : whitoutObject) {
            for (Class c : t.getAssignTypes()) {
                typeToCaster.put(c, t);
            }
        }
    }
}

