/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.reflect;

public class PrimitiveTools {
    public static final Integer INT_ZERO = 0;
    public static final Integer INT_ONE = 1;
    public static final Integer INT_TWO = 2;
    public static final Integer INT_TEN = 3;

    public static String objectifyPrimitiveName(String name, String def) {
        switch (name) {
            case "void": {
                return "Void";
            }
            case "boolean": {
                return "Boolean";
            }
            case "byte": {
                return "Byte";
            }
            case "char": {
                return "Character";
            }
            case "short": {
                return "Short";
            }
            case "int": {
                return "Integer";
            }
            case "long": {
                return "Long";
            }
            case "float": {
                return "Float";
            }
            case "double": {
                return "Double";
            }
        }
        return def;
    }

    public static Class toObjectClassType(Class cls, Class def) {
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        return def;
    }

    public static Class<?> translatePrimitiveToObjectType(Class<?> prim) {
        if (prim == Integer.TYPE) {
            return Integer.class;
        }
        if (prim == Long.TYPE) {
            return Long.class;
        }
        if (prim == Double.TYPE) {
            return Double.class;
        }
        if (prim == Float.TYPE) {
            return Float.class;
        }
        if (prim == Byte.TYPE) {
            return Byte.class;
        }
        if (prim == Short.TYPE) {
            return Short.class;
        }
        if (prim == Boolean.TYPE) {
            return Boolean.class;
        }
        if (prim == Character.TYPE) {
            return Character.class;
        }
        return prim;
    }

    public static boolean isPrimitiveTypeObject(Class<?> cls) {
        return cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(Byte.class) || cls.equals(Short.class) || cls.equals(Integer.class) || cls.equals(Float.class) || cls.equals(Long.class) || cls.equals(Double.class);
    }

    public static boolean isPrimitiveClass(Class<? extends Object> cls) {
        return null != PrimitiveTools.toObjectClassType(cls, null);
    }
}

