/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.multithread.MultithreadingTools;
import eu.javaexperience.multithreading.pools.TimeoutJobPool;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Global {
    private static final Properties prop = new Properties();
    protected static final String PROP_NOT_SPECIFIED_ERR = "Property not specified: ";

    private Global() {
    }

    public static Object putProperty(Object str, Object obj) {
        return prop.put(str, obj);
    }

    public static Object getProperty(Object str) {
        return prop.get(str);
    }

    public static Set<Map.Entry<Object, Object>> getAllPropertySet() {
        return prop.entrySet();
    }

    public static boolean tryParseGlobalBoolean(String key) {
        Object val = Global.getProperty(key);
        try {
            if (null == val) {
                throw new IllegalArgumentException(PROP_NOT_SPECIFIED_ERR + key);
            }
            return Boolean.parseBoolean(val.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid boolean property: key: " + key + ", value: " + val, e);
        }
    }

    public static int tryParseGlobalInt(String key) {
        Object val = Global.getProperty(key);
        try {
            if (null == val) {
                throw new IllegalArgumentException(PROP_NOT_SPECIFIED_ERR + key);
            }
            return Integer.parseInt(val.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid int property: key: " + key + ", value: " + val, e);
        }
    }

    public static String tryParseGlobalString(String key) {
        Object val = Global.getProperty(key);
        if (null == val) {
            throw new IllegalArgumentException(PROP_NOT_SPECIFIED_ERR + key);
        }
        return val.toString();
    }

    public static LogLevel tryParseGlobalLoglevel(String key) {
        String str = Global.tryParseGlobalString(key);
        LogLevel ret = null;
        str = str.toUpperCase();
        try {
            ret = LogLevel.valueOf(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad Loglevel specification (only " + Arrays.toString(LogLevel.values()) + " are recognised)", e);
        }
        return ret;
    }

    public static <E extends Enum<E>> E tryParseGlobalEnum(Class<E> clss, String key) {
        String str = Global.tryParseGlobalString(key);
        E ret = null;
        ret = ParsePrimitive.tryParseEnum(clss, str);
        if (null == ret) {
            throw new IllegalArgumentException("Bad enum specification for `" + key + "` (only " + Arrays.toString(clss.getEnumConstants()) + " are recognised)");
        }
        return ret;
    }

    public static Map<String, Object> getAsMap() {
        SmallMap<String, Object> ret = new SmallMap<String, Object>();
        for (Map.Entry<Object, Object> p : prop.entrySet()) {
            ret.put(StringTools.toString(p.getKey()), p.getValue());
        }
        return ret;
    }

    public static void loadFromFile(String file) {
        try (FileReader fr = new FileReader(file);){
            Properties props = new Properties();
            props.load(fr);
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                Global.putProperty(kv.getKey(), kv.getValue());
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
    }

    public static class LazySingletons {
        private static TimeoutJobPool timeouts = new TimeoutJobPool();

        private LazySingletons() {
        }

        public static TimeoutJobPool timeoutJobPool() {
            return timeouts;
        }

        public static void repeatJob(final SimpleCall c, final int delayNextRun, final boolean ignoreException, int firstRunDelay) {
            LazySingletons.timeoutJobPool().putTimoutJob(firstRunDelay >= 0 ? firstRunDelay : delayNextRun, new SimpleCall(){

                @Override
                public void call() {
                    try {
                        c.call();
                    }
                    catch (Throwable t) {
                        if (t == MultithreadingTools.THREAD_SHUTDOWN_POISON) {
                            throw t;
                        }
                        if (ignoreException) {
                            LazySingletons.timeoutJobPool().putTimoutJob(delayNextRun, this);
                        }
                        return;
                    }
                    LazySingletons.timeoutJobPool().putTimoutJob(delayNextRun, this);
                }
            });
        }
    }
}

