/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphPath;
import eu.javaexperience.algorithm.search.graph.GraphSearchDirection;
import eu.javaexperience.algorithm.search.graph.GraphSearchSubject;
import eu.javaexperience.algorithm.search.graph.GraphSearchVertexTransition;
import eu.javaexperience.algorithm.search.graph.GraphSearcher;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.reflect.Mirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphSearchTraveledPath<V, E>
implements ExternalDataAttached {
    protected final GraphSearcher<V, E> graphSearch;
    protected GraphSearchDirection direction;
    protected GraphPath<V, E> path;
    protected int forkCount = 0;
    protected ArrayList<Map.Entry<E, V>> neighborNodes = null;
    protected Set<Map.Entry<E, V>> processedNeighborVertexes = new HashSet<Map.Entry<E, V>>();
    protected Map<String, Object> extraData;

    public GraphSearchTraveledPath(GraphSearcher<V, E> graphSearch, GraphSearchDirection direction) {
        this.graphSearch = graphSearch;
        this.direction = direction;
        this.path = new GraphPath();
    }

    public V getFirstVertex() {
        return this.path.first.getFrom();
    }

    public V getLastVertex() {
        return this.path.last.getTo();
    }

    public GraphSearchVertexTransition<V, E> getFirstNode() {
        return this.path.first;
    }

    public GraphSearchVertexTransition<V, E> getLastNode() {
        return this.path.last;
    }

    public GraphSearchDirection getSearchDirection() {
        return this.direction;
    }

    public GraphSearchTraveledPath<V, E> copy() {
        GraphSearchTraveledPath<V, E> ret = new GraphSearchTraveledPath<V, E>(this.graphSearch, this.direction);
        try {
            ret.path = this.path.clone();
        }
        catch (CloneNotSupportedException e) {
            Mirror.propagateAnyway(e);
        }
        ret.neighborNodes = null;
        ret.processedNeighborVertexes = new HashSet<Map.Entry<E, V>>();
        return ret;
    }

    public V getDirectionVertex() {
        switch (this.direction) {
            case BACKWARD: {
                return this.getFirstVertex();
            }
            case BIDIRECTIONAL: {
                return null;
            }
            case FORWARD: {
                return this.getLastVertex();
            }
        }
        throw new UnimplementedCaseException(this.direction);
    }

    public V getDirectionPrevVertex() {
        switch (this.direction) {
            case BACKWARD: {
                return this.getFirstNode().getTo();
            }
            case BIDIRECTIONAL: {
                return null;
            }
            case FORWARD: {
                return this.getLastNode().getFrom();
            }
        }
        throw new UnimplementedCaseException(this.direction);
    }

    public Map.Entry<E, V> getDirectionPrevVertexEntry() {
        switch (this.direction) {
            case BACKWARD: {
                return new KeyVal(this.getFirstNode().getEdge(), this.getFirstNode().getTo());
            }
            case BIDIRECTIONAL: {
                return null;
            }
            case FORWARD: {
                return new KeyVal(this.getFirstNode().getEdge(), this.getLastNode().getFrom());
            }
        }
        throw new UnimplementedCaseException(this.direction);
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public List<Map.Entry<E, V>> getOrCacheNeighborNodes(GraphSearchSubject<V, E> subject) {
        if (null == this.neighborNodes) {
            this.neighborNodes = new ArrayList();
            subject.fillNeighborVertexes(this.getDirectionVertex(), this.neighborNodes);
        }
        return this.neighborNodes;
    }

    public GraphSearchTraveledPath<V, E> fork(GraphSearchSubject<V, E> subject, Map.Entry<E, V> node) {
        GraphSearchTraveledPath ob = this;
        GraphSearchDirection dir = ob.getSearchDirection();
        GraphSearchTraveledPath<V, E> ret = ob.copy();
        if (dir == GraphSearchDirection.BACKWARD || dir == GraphSearchDirection.BIDIRECTIONAL && ob.getFirstVertex() == node) {
            ret.getFirstNode().addVertexBackward(node.getValue(), node.getKey());
        } else if (dir == GraphSearchDirection.FORWARD || dir == GraphSearchDirection.BIDIRECTIONAL && ob.getLastVertex() == node) {
            ret.getLastNode().addVertexForward(node.getKey(), node.getValue());
        } else {
            throw new UnimplementedCaseException(ob.getSearchDirection());
        }
        this.processedNeighborVertexes.add(node);
        ++this.forkCount;
        return ret;
    }

    public boolean hasUndiscoveredBranch(GraphSearchSubject<V, E> subj) {
        return this.getOrCacheNeighborNodes(subj).size() > this.processedNeighborVertexes.size();
    }

    public void fillOpenVertexes(GraphSearcher<V, E> search, Collection<Map.Entry<E, V>> dst) {
        for (Map.Entry v : this.getOrCacheNeighborNodes(search.subject)) {
            if (this.processedNeighborVertexes.contains(v)) continue;
            dst.add(v);
        }
    }

    public GraphSearchTraveledPath<V, E> merge(GraphSearchTraveledPath<V, E> with) {
        if (this.getFirstVertex().equals(with.getLastVertex())) {
            GraphSearchTraveledPath<V, E> ret = new GraphSearchTraveledPath<V, E>(this.graphSearch, this.direction);
            ret.neighborNodes = this.neighborNodes;
            ret.processedNeighborVertexes = this.processedNeighborVertexes;
            ret.path = with.path.merge(this.path);
            this.processedNeighborVertexes.add(with.getDirectionPrevVertexEntry());
            with.processedNeighborVertexes.add(this.getDirectionPrevVertexEntry());
            return ret;
        }
        if (this.getLastVertex().equals(with.getFirstVertex())) {
            GraphSearchTraveledPath<V, E> ret = new GraphSearchTraveledPath<V, E>(this.graphSearch, this.direction);
            ret.neighborNodes = with.neighborNodes;
            ret.processedNeighborVertexes = with.processedNeighborVertexes;
            ret.path = this.path.merge(with.path);
            this.processedNeighborVertexes.add(with.getDirectionPrevVertexEntry());
            with.processedNeighborVertexes.add(this.getDirectionPrevVertexEntry());
            return ret;
        }
        throw new RuntimeException("Can't merge `" + this + "` with `" + with + "`");
    }

    public String toString() {
        return "GraphSearchTraveledPath: " + this.path;
    }

    public boolean hasFork() {
        return this.forkCount > 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphSearchTraveledPath)) {
            return false;
        }
        return this.path.equals(((GraphSearchTraveledPath)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap<String, Object>();
        }
        return this.extraData;
    }
}

