/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.cli;

import eu.javaexperience.cli.CliTools;
import eu.javaexperience.collection.CollectionReadOnlyFunctions;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.ReadOnlyAndRwCollection;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CliEntry<T> {
    protected ReadOnlyAndRwCollection<List<String>> opts = new ReadOnlyAndRwCollection<List>(new ArrayList(), CollectionReadOnlyFunctions.MAKE_LIST_READ_ONLY);
    protected String description;
    protected GetBy2<T, CliEntry<T>, Map<String, List<String>>> parser;

    public CliEntry(GetBy2<T, CliEntry<T>, Map<String, List<String>>> parser, String descr, String ... opt) {
        this.parser = parser;
        CollectionTools.copyInto(opt, this.opts.getWriteable());
    }

    private CliEntry(String descr, String ... opt) {
        this.description = descr;
        CollectionTools.copyInto(opt, this.opts.getWriteable());
    }

    public static <T> CliEntry<T> createFirstArgParserEntry(GetBy1<T, String> parser, String descr, String ... opt) {
        CliEntry<T> ret = new CliEntry<T>(descr, opt);
        ret.parser = CliTools.createParser(parser, ret.createFirstArgExaminer());
        return ret;
    }

    public GetBy1<String, Map<String, List<String>>> createFirstArgExaminer() {
        return new GetBy1<String, Map<String, List<String>>>(){

            @Override
            public String getBy(Map<String, List<String>> a) {
                return CliEntry.this.getSimple(a);
            }
        };
    }

    public List<String> getOptionNames() {
        return this.opts.getReadOnly();
    }

    public String getDescription() {
        return this.description;
    }

    public T tryParse(Map<String, List<String>> from) {
        try {
            return this.parser.getBy(this, from);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error on parsing CliEntry: " + this.toString());
        }
    }

    public T tryParseOrDefault(Map<String, List<String>> from, T def) {
        T ret = this.parser.getBy(this, from);
        if (null != ret) {
            return ret;
        }
        return def;
    }

    public boolean hasOption(Map<String, List<String>> from) {
        for (String name : this.getOptionNames()) {
            if (!from.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public String getSimple(Map<String, List<String>> from) {
        for (String s : this.opts.getReadOnly()) {
            List<String> re = from.get(s);
            if (null == re || re.size() <= 0) continue;
            return re.get(0);
        }
        return null;
    }

    public List<String> getFirst(Map<String, List<String>> from) {
        for (String s : this.opts.getReadOnly()) {
            List<String> re = from.get(s);
            if (null == re) continue;
            return re;
        }
        return null;
    }

    public List<String> getAll(Map<String, List<String>> from) {
        ArrayList ret = null;
        for (String s : this.opts.getReadOnly()) {
            List<String> re = from.get(s);
            if (null == re) continue;
            if (null == ret) {
                ret = new ArrayList();
            }
            CollectionTools.copyInto(re, ret);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        int n = 0;
        for (String o : this.getOptionNames()) {
            if (++n > 1) {
                sb.append(", ");
            }
            sb.append("-");
            sb.append(o);
        }
        sb.append("\t\t");
        sb.append(this.getDescription());
        return sb.toString();
    }
}

