/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection;

import eu.javaexperience.collection.iterator.OneShotIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class OneShotCollection<E>
implements Collection<E> {
    protected final E element;

    public OneShotCollection(E element) {
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new OneShotIterator<E>(this.element);
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] ret = Arrays.copyOf(a, 1);
        ret[0] = this.element;
        return ret;
    }

    @Override
    public boolean add(E e) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 1) {
            return false;
        }
        for (Object o : c) {
            if (o == this.element) {
                return true;
            }
            if (o == null) continue;
            return o.equals(this.element);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

