/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.search;

import eu.javaexperience.collection.search.MatrixMapDistanceCalcualtor;
import java.util.ArrayList;
import java.util.Collection;

public class MatrixMap<E> {
    protected final MatrixMapDistanceCalcualtor<E> calc;
    protected ArrayList<E> values = new ArrayList();
    protected final float[] matrix;

    public static MatrixMapDistanceCalcualtor findCalculator(Collection<?> coll) {
        for (Object c : coll) {
            if (!(c instanceof MatrixMapDistanceCalcualtor)) continue;
            return (MatrixMapDistanceCalcualtor)c;
        }
        return null;
    }

    public MatrixMap(Collection<E> coll) {
        this.values.addAll(coll);
        this.calc = MatrixMap.findCalculator(this.values);
        if (null == this.calc) {
            throw new RuntimeException("No element in the collection implements MatrixMapDistanceCalcualtor.");
        }
        int len = this.values.size();
        this.matrix = new float[len * len];
    }

    public MatrixMap(Collection<E> coll, MatrixMapDistanceCalcualtor<E> calc) {
        this.values.addAll(coll);
        this.calc = calc;
        if (null == calc) {
            throw new RuntimeException("Calculator may not null");
        }
        int len = this.values.size();
        this.matrix = new float[len * len];
    }

    public void calculate() {
        int len = this.values.size();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                this.matrix[i * len + j] = this.calc.calculate(this.values.get(i), this.values.get(j));
            }
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.values.size();
    }

    protected int access(E elem) {
        int index = this.values.indexOf(elem);
        if (index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        return index;
    }

    public float getAtoB(E a, E b) {
        int ia = this.access(a);
        int ib = this.access(b);
        return this.matrix[ia * this.values.size() + ib];
    }
}

