/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.config;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.semantic.designedfor.Immutable;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.verify.WeightedValidationReportEntry;
import java.util.ArrayList;
import java.util.Collection;

public abstract class ConfigurableUnit<C, U, V> {
    protected ConfigurableUnitState state = ConfigurableUnitState.UNCONFIGURED_NEW_UNIT;
    protected String name;
    protected C currentConfig;
    protected C desiredConfig;
    protected U unit;

    public ConfigurableUnit(String name) {
        this.name = name;
    }

    public synchronized ConfigurableUnitState getState() {
        return this.state;
    }

    public synchronized void setConfig(@Immutable C cfg) {
        this.checkStateAndSetValidatedConfig(cfg);
    }

    protected void checkStateAndSetValidatedConfig(C cfg) {
        if (this.state == ConfigurableUnitState.DESTROYED) {
            throw new RuntimeException("Can't set new configuration to " + this.toString() + " because it's already destroyed");
        }
        ArrayList<WeightedValidationReportEntry<V>> v = new ArrayList<WeightedValidationReportEntry<V>>();
        if (!this.validateConfig(cfg, v)) {
            throw new RuntimeException("New Configuration: `" + cfg + "` for: `" + this.toString() + "` is invalid. ValidationEntries: " + CollectionTools.toStringMultiline(v));
        }
        this.desiredConfig = cfg;
        this.state = this.state == ConfigurableUnitState.UNCONFIGURED_NEW_UNIT ? ConfigurableUnitState.VALID_CONFIGURATION_SET : ConfigurableUnitState.BEFORE_UPGRADE;
    }

    public abstract boolean validateConfig(C var1, Collection<WeightedValidationReportEntry<V>> var2);

    public void assertHasConfig() {
        if (this.state != ConfigurableUnitState.VALID_CONFIGURATION_SET && this.state != ConfigurableUnitState.BEFORE_UPGRADE) {
            throw new RuntimeException(this.toString() + " has no valid configuration, can not be initalized.");
        }
    }

    public C getCurrentConfig() {
        return this.currentConfig;
    }

    public C getDesiredConfigfuration() {
        return this.desiredConfig;
    }

    public synchronized void initialize() {
        this.assertNotDestroyed();
        this.assertHasConfig();
        this.unit = this.internalInitalize(this.desiredConfig, this.unit);
        this.currentConfig = this.desiredConfig;
        this.desiredConfig = null;
        this.state = ConfigurableUnitState.INITIALIZED;
    }

    public synchronized void rollback() {
        if (ConfigurableUnitState.INITIALIZED == this.state) {
            throw new RuntimeException("Can't rollback unit: already initalized.");
        }
        this.assertNotDestroyed();
        this.assertHasConfig();
        this.desiredConfig = null;
        switch (this.state) {
            case UNCONFIGURED_NEW_UNIT: 
            case DESTROYED: 
            case INITIALIZED: {
                throw new RuntimeException("Bad synchronization, ConfigurableUnit is in an illegal state `" + (Object)((Object)this.state) + "` after state check in a synchronized block");
            }
            case BEFORE_UPGRADE: {
                this.state = ConfigurableUnitState.UNCONFIGURED_NEW_UNIT;
                break;
            }
            case VALID_CONFIGURATION_SET: {
                this.state = ConfigurableUnitState.INITIALIZED;
                break;
            }
            default: {
                throw new UnimplementedCaseException(this.state);
            }
        }
    }

    protected abstract U internalInitalize(C var1, @MayNull U var2);

    public synchronized void destroy() {
        this.assertNotDestroyed();
        this.state = ConfigurableUnitState.DESTROYED;
        this.internalDestroy(this.unit);
        this.unit = null;
    }

    protected abstract void internalDestroy(U var1);

    public void assetUnitReady() {
        this.assertNotDestroyed();
        this.assertUnitInitalized();
    }

    public void assertNotDestroyed() {
        if (this.state == ConfigurableUnitState.DESTROYED) {
            throw new IllegalStateException(this.toString() + " already destroyed");
        }
    }

    public void assertUnitInitalized() {
        if (this.state == ConfigurableUnitState.VALID_CONFIGURATION_SET || this.state == ConfigurableUnitState.UNCONFIGURED_NEW_UNIT) {
            throw new IllegalStateException(this.toString() + " not yet initalized");
        }
    }

    public synchronized U getUnit() {
        this.assetUnitReady();
        return this.unit;
    }

    public String toString() {
        return "ConfigurableUnit(" + this.name + ")";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static String formatName(Class cls, String userDefinedName) {
        return cls.getSimpleName() + "[" + userDefinedName + "]";
    }

    public static enum ConfigurableUnitState {
        UNCONFIGURED_NEW_UNIT,
        VALID_CONFIGURATION_SET,
        INITIALIZED,
        BEFORE_UPGRADE,
        DESTROYED;

    }
}

