/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.csv;

import eu.javaexperience.csv.SimpleCSVOutput;
import eu.javaexperience.datatable.DataTableStructure;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.text.StringTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public class CSVTools {
    public static final GetBy3<String, Object[], Integer, String> DATATABLE_ARRAY_EXAMINER = new GetBy3<String, Object[], Integer, String>(){

        @Override
        public String getBy(Object[] a, Integer b, String c) {
            return StringTools.toStringOrNull(a[b]);
        }
    };
    public static final String[] HEADER_READ_COLUMN_NAMES = CSVTools.generateColHeader(50);

    public static int getIndexByExcelColumn(String column_name) {
        if (null == column_name) {
            return -1;
        }
        column_name = column_name.toUpperCase();
        int ret = 0;
        int w = 0;
        int i = column_name.length() - 1;
        while (i > -1) {
            char c = column_name.charAt(i);
            if ('A' > c || c > 'Z') {
                return -1;
            }
            ret = (int)((double)ret + Math.pow(26.0, w) * (double)(c - 65 + 1));
            --i;
            ++w;
        }
        return ret - 1;
    }

    private static final char[] increment(char[] in, int index) {
        if (in.length == 0) {
            return new char[]{'A'};
        }
        if (in[index] == 'Z') {
            in[index] = 65;
            if (index == 0) {
                char[] ret = new char[in.length + 1];
                ret[0] = 65;
                for (int i = 0; i < in.length; ++i) {
                    ret[i + 1] = in[i];
                }
                return ret;
            }
            return CSVTools.increment(in, index - 1);
        }
        int n = index;
        in[n] = (char)(in[n] + '\u0001');
        return in;
    }

    public static String[] generateColHeader(int n) {
        String[] ret = new String[n];
        char[] val = new char[]{};
        for (int i = 0; i < n; ++i) {
            val = CSVTools.increment(val, val.length - 1);
            ret[i] = new String(val);
        }
        return ret;
    }

    public static String removeUnnecessaryQuote(String str, char quote) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("\ufeff")) {
            str = str.substring(1);
        }
        if (str.indexOf(quote) == 0) {
            str = str.substring(1);
        }
        if (str.lastIndexOf(quote) == str.length() - 1) {
            if (str.length() < 2) {
                return "";
            }
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void examinePrefixColumns(Collection<String> dst, Map<String, String> row, String prefix) {
        for (Map.Entry<String, String> kv : row.entrySet()) {
            String val;
            if (!kv.getKey().startsWith(prefix) || StringTools.isNullOrTrimEmpty(val = kv.getValue())) continue;
            dst.add(val);
        }
    }

    public static void writeDatatableToFile(String dstFile, DataTableStructure<Object[]> src) throws IOException {
        CSVTools.writeDatatableToFile(dstFile, src, DATATABLE_ARRAY_EXAMINER);
    }

    public static <T> void writeDatatableToFile(String dstFile, DataTableStructure<T> src, GetBy3<String, T, Integer, String> tableEntryExamine) throws IOException {
        try (PrintWriter pw = new PrintWriter(dstFile);){
            SimpleCSVOutput out = new SimpleCSVOutput(pw);
            String[] rowNames = src.getRowNames();
            out.putRow(rowNames);
            String[] drow = new String[rowNames.length];
            for (T t : src.getDataCursor()) {
                for (int i = 0; i < rowNames.length; ++i) {
                    drow[i] = tableEntryExamine.getBy(t, i, rowNames[i]);
                }
                out.putRow(drow);
            }
            pw.flush();
        }
    }

    public static void main(String[] args) {
        String[] cols;
        System.out.println(CSVTools.getIndexByExcelColumn("A"));
        System.out.println(CSVTools.getIndexByExcelColumn("B"));
        System.out.println(CSVTools.getIndexByExcelColumn("C"));
        System.out.println(CSVTools.getIndexByExcelColumn("Z"));
        System.out.println(CSVTools.getIndexByExcelColumn("AA"));
        System.out.println(CSVTools.getIndexByExcelColumn("AZ"));
        System.out.println(CSVTools.getIndexByExcelColumn("BA"));
        for (String s : cols = CSVTools.generateColHeader(1000)) {
            System.out.println(s);
        }
    }
}

