/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.csv;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.csv.CSVTools;
import eu.javaexperience.reflect.Mirror;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;

public class SillyCSVFormatReader
implements AutoCloseable,
Closeable {
    protected BufferedReader br;
    protected InputStream is;
    protected String[] rows;
    protected final char quote;
    protected final char delimiter;
    protected final String strQuote;
    protected final URL url;
    protected final Charset charset;

    public SillyCSVFormatReader(File file, char quote, char delimiter, Charset charset, String[] rows) throws MalformedURLException {
        this(new URL("file://" + file.toString()), quote, delimiter, charset, rows);
    }

    public SillyCSVFormatReader(URL url, char quote, char delimiter, Charset charset, String[] rows) {
        this.charset = charset;
        this.url = url;
        this.rows = rows;
        this.quote = quote;
        this.strQuote = new String(new char[]{quote});
        this.delimiter = delimiter;
    }

    public void init() throws IOException {
        URLConnection conn = this.url.openConnection();
        this.is = conn.getInputStream();
        this.br = this.charset == null ? new BufferedReader(new InputStreamReader(this.is)) : new BufferedReader(new InputStreamReader(this.is, this.charset));
    }

    public Map<String, String> getRow() {
        SmallMap<String, String> ret = new SmallMap<String, String>();
        String line = null;
        try {
            line = this.br.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (SillyCSVFormatReader.getRow(line, this.rows, ret, this.quote, this.delimiter)) {
            return ret;
        }
        return null;
    }

    public static boolean getRow(String line, String[] rows, Map<String, String> ret, char quote, char delimiter) {
        if (line == null) {
            return false;
        }
        int unit = 0;
        int poz = 0;
        StringBuilder sb = new StringBuilder();
        boolean prev_delim = false;
        boolean prev_quote = false;
        boolean delim_eou = false;
        while (unit < rows.length && poz < line.length()) {
            char at;
            if ((at = line.charAt(poz++)) == quote) {
                if (prev_quote && sb.length() > 0) {
                    sb.append(quote);
                    prev_delim = false;
                    prev_quote = false;
                    continue;
                }
                if (sb.length() == 0) {
                    delim_eou = true;
                } else if (prev_quote) {
                    sb.append(quote);
                }
                prev_delim = false;
                prev_quote = true;
                continue;
            }
            if (at == delimiter) {
                if (prev_quote && delim_eou || !delim_eou) {
                    ret.put(rows[unit++], CSVTools.removeUnnecessaryQuote(sb.toString(), quote));
                    sb = new StringBuilder();
                    prev_quote = false;
                    prev_delim = false;
                    delim_eou = false;
                } else {
                    sb.append(delimiter);
                }
                prev_quote = false;
                prev_delim = true;
                continue;
            }
            if (prev_delim && sb.length() == 0) {
                delim_eou = false;
            }
            sb.append(at);
            prev_delim = false;
            prev_quote = false;
        }
        if (unit < rows.length) {
            ret.put(rows[unit++], CSVTools.removeUnnecessaryQuote(sb.toString(), quote));
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
        this.is.close();
    }

    public void setRowNames(String[] ret) {
        this.rows = ret;
    }

    public void readHeaders() {
        this.rows = CSVTools.HEADER_READ_COLUMN_NAMES;
        Map<String, String> row = this.getRow();
        this.rows = row.values().toArray(Mirror.emptyStringArray);
    }
}

