/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.csv;

import java.io.IOException;

public class SimpleCSVOutput {
    protected final Appendable sb;
    protected char separator = (char)44;
    protected boolean escape_linebreaks = true;
    protected int ep = 0;

    public boolean isEscapeLinebreaks() {
        return this.escape_linebreaks;
    }

    public void setEscapeLinebreaks(boolean escape_linebreaks) {
        this.escape_linebreaks = escape_linebreaks;
    }

    public SimpleCSVOutput(Appendable out) {
        this.sb = out;
    }

    public void putRow(String ... arguments) throws IOException {
        if (this.ep++ > 0) {
            this.sb.append("\r\n");
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                this.sb.append(this.separator);
            }
            this.escapeCsv(arguments[i]);
        }
    }

    protected void escapeCsv(String str) throws IOException {
        if (null == str) {
            str = "";
        }
        this.sb.append("\"");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (this.escape_linebreaks) {
                if (c == '\n') {
                    this.sb.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    this.sb.append("\\r");
                    continue;
                }
            }
            if (c == '\"') {
                this.sb.append("\"\"");
                continue;
            }
            this.sb.append(c);
        }
        this.sb.append("\"");
    }

    public String toString() {
        return "SimpleCsvOutput: " + this.sb.toString();
    }

    public Appendable getBackendAppendable() {
        return this.sb;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

