/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public enum ConnectionBuilder {
    mysql("mysql", 3306, "?characterEncoding=UTF-8&autoReconnect=true", "com.mysql.jdbc.Driver"),
    postgresql("postgresql", 5432, "", "org.postgresql.Driver"),
    sqlite("sqlite", -1, "", "org.sqlite.JDBC");

    private final String name;
    private final int defaultPort;
    private final String urlExtra;

    private ConnectionBuilder(String name, int defaultPort, String urlExtra, String ... possibleClasses) {
        this.name = name;
        this.defaultPort = defaultPort;
        this.urlExtra = urlExtra;
        for (String p : possibleClasses) {
            try {
                Class.forName(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Connection openConnection(String host, String user, String password, String database) throws SQLException {
        return this.openConnection(host, this.defaultPort, user, password, database);
    }

    public Connection openConnection(String user, String password, String database) throws SQLException {
        return this.openConnection("localhost", this.defaultPort, user, password, database);
    }

    public Connection openConnection(String host, int port, String user, String password, String database) throws SQLException {
        if (port < 1) {
            if (this.defaultPort < 0) {
                return DriverManager.getConnection("jdbc:" + this.name + ":" + database + this.urlExtra, user, password);
            }
            return DriverManager.getConnection("jdbc:" + this.name + "://" + database + this.urlExtra, user, password);
        }
        return DriverManager.getConnection("jdbc:" + this.name + "://" + host + ":" + String.valueOf(port) + "/" + database + this.urlExtra, user, password);
    }

    public Connection openConnection(String host, int port, String user, String password, String database, Properties props) throws SQLException {
        if (port < 1) {
            return DriverManager.getConnection("jdbc:" + this.name + "://" + database + this.urlExtra, user, password);
        }
        return DriverManager.getConnection("jdbc:" + this.name + "://" + host + ":" + String.valueOf(port) + "/" + database + this.urlExtra, user, password);
    }

    public static Connection openConnection(Class<? extends Driver> driver, String DBtype, String host, int port, String user, String password, String database) throws SQLException {
        driver.getName();
        return DriverManager.getConnection("jdbc:" + DBtype + "://" + host + ":" + String.valueOf(port) + "/" + database, user, password);
    }
}

