/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.accessModel;

import eu.javaexperience.database.accessModel.OptionEntry;
import eu.javaexperience.database.accessModel.WellKnownAccessQueryOptions;
import eu.javaexperience.reflect.Mirror;
import java.util.ArrayList;
import java.util.List;

public class OptionGroup {
    protected String userFriendlyName;
    protected String systemName;
    protected List<OptionEntry> options = new ArrayList<OptionEntry>();

    public OptionGroup(WellKnownAccessQueryOptions systemName, String userFiendlyName, OptionEntry ... options) {
        this(systemName.name(), userFiendlyName, options);
    }

    public OptionGroup(String systemName, String userFiendlyName, OptionEntry ... options) {
        this.systemName = systemName;
        this.userFriendlyName = userFiendlyName;
        for (OptionEntry o : options) {
            this.options.add(o);
            o.owner = this;
        }
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void addOptions(OptionEntry ... opt) {
        for (OptionEntry o : opt) {
            this.options.add(o);
            o.owner = this;
        }
    }

    public void overrideOptions(OptionEntry ... opts) {
        this.options.clear();
        this.addOptions(opts);
    }

    public boolean isValuePermitted(String val) {
        for (OptionEntry e : this.options) {
            if (!Mirror.equals(val, e.optionAddress)) continue;
            return true;
        }
        return false;
    }
}

