/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.collection;

import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.collection.JdbcMap;
import eu.javaexperience.reflect.Mirror;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcMapImplProviders {
    public static void sqliteCreateKeyValTable(Connection conn, String table) throws SQLException {
        JDBC.execute(conn, "CREATE TABLE IF NOT EXISTS `" + table + "` (`key` VARCHAR(500) PRIMARY KEY, `val` VARCHAR(500))");
    }

    public static void mysqlCreateKeyValTable(Connection conn, String table) throws SQLException {
        JDBC.execute(conn, "CREATE TABLE IF NOT EXISTS `" + table + "` (`key` CHAR(120) PRIMARY KEY, val CHAR(120))");
    }

    public static JdbcMap.JdbcMapImplProvider<String, String> fromPrepared(final Connection conn, final String table, final String insertOrUpdate) {
        return new JdbcMap.JdbcMapImplProvider<String, String>(){

            @Override
            public Connection getConnection() {
                try {
                    return conn;
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public void releaseConnection(Connection conn2) {
            }

            @Override
            public ResultSet selectWhereKey(Connection conn2, String key) {
                try {
                    PreparedStatement ps = conn2.prepareStatement("SELECT `key`, `val` FROM " + table + " WHERE `key` = ?");
                    ps.setObject(1, key);
                    return ps.executeQuery();
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public ResultSet selectWhereValue(Connection conn2, String val) {
                try {
                    PreparedStatement ps = conn2.prepareStatement("SELECT `key`, `val` FROM " + table + " WHERE `val` = ?");
                    ps.setObject(1, val);
                    return ps.executeQuery();
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public ResultSet selectAll(Connection conn2) {
                try {
                    PreparedStatement ps = conn2.prepareStatement("SELECT `key`, `val` FROM " + table);
                    return ps.executeQuery();
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public String extractKey(ResultSet rs) {
                try {
                    return (String)rs.getObject("key");
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public String extractValue(ResultSet rs) {
                try {
                    return (String)rs.getObject("val");
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public String insertOrUpdate(Connection conn2, String key, String value) {
                try {
                    PreparedStatement ps = conn2.prepareStatement(insertOrUpdate);
                    ps.setObject(1, key);
                    ps.setObject(2, value);
                    ps.execute();
                    return null;
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public String removeByKey(Connection conn2, Object key) {
                try {
                    PreparedStatement ps = conn2.prepareStatement("DELETE FROM " + table + " WHERE `key` = ?");
                    ps.setObject(1, key);
                    ps.execute();
                    return null;
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return null;
                }
            }

            @Override
            public int getMappingCount(Connection conn2) {
                try {
                    return JDBC.getInt(conn2, "SELECT count(1) FROM " + table);
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    return -1;
                }
            }

            @Override
            public void emptyOutMapping(Connection conn2) {
                try {
                    JDBC.execute(conn2, "DELETE FROM " + table);
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                }
            }
        };
    }

    public static JdbcMap.JdbcMapImplProvider<String, String> sqlite(Connection conn, String table) {
        return JdbcMapImplProviders.fromPrepared(conn, table, "INSERT OR REPLACE INTO " + table + " (`key`, `val`) VALUES (?, ?);");
    }

    public static JdbcMap.JdbcMapImplProvider<String, String> mysql(Connection conn, String table) {
        return JdbcMapImplProviders.fromPrepared(conn, table, "REPLACE INTO " + table + " (`key`, `val`) VALUES (?, ?);");
    }
}

