/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datastorage.javaImpl;

import eu.javaexperience.collection.map.TransactionMap;
import eu.javaexperience.datastorage.DataTransaction;
import eu.javaexperience.datastorage.TransactionException;
import eu.javaexperience.reflect.Mirror;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class JavaDataTransaction
implements DataTransaction {
    protected TransactionMap<String, Object> transactionMap;
    protected boolean closed = false;

    public JavaDataTransaction(Map<String, Object> origin) {
        this.transactionMap = new TransactionMap<String, Object>(origin);
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new RuntimeException("DataStorage is already closed");
        }
    }

    @Override
    public int size() {
        this.assertOpen();
        return this.transactionMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.assertOpen();
        return this.transactionMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.assertOpen();
        return this.transactionMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.assertOpen();
        return this.transactionMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        this.assertOpen();
        return this.transactionMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        this.assertOpen();
        return this.transactionMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this.assertOpen();
        return this.transactionMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.assertOpen();
        this.transactionMap.putAll(m);
    }

    @Override
    public void clear() {
        this.assertOpen();
        this.transactionMap.clear();
    }

    @Override
    public Set<String> keySet() {
        this.assertOpen();
        return this.transactionMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.assertOpen();
        return this.transactionMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.assertOpen();
        return this.transactionMap.entrySet();
    }

    @Override
    public void rollback() {
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws TransactionException {
        Map<String, Object> origin;
        Map<String, Object> map = origin = this.transactionMap.getOriginalMap();
        synchronized (map) {
            Map<String, Object> access = this.transactionMap.getAccessMap();
            for (Map.Entry<String, Object> kv : access.entrySet()) {
                Object a;
                String k = kv.getKey();
                Object o = origin.get(k);
                if (Mirror.equals(o, a = this.transactionMap.getAccessTimeValue(k))) continue;
                throw new TransactionException("Data under key `" + k + "` modified by another thread since transaction started. Try again.");
            }
            origin.putAll(this.transactionMap.getDiffMap());
        }
    }
}

