/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class AppendableLocklessWriter
extends PrintWriter {
    protected final Appendable app;
    protected Formatter formatter = null;
    protected boolean autoFlush;
    protected String lineSeparator = String.format("%n", new Object[0]);
    private char[] buf = new char[1];

    public AppendableLocklessWriter(Appendable app) {
        super(IOTools.nullWriter, true);
        this.app = app;
        AssertArgument.assertNotNull(this.app, "Appendable");
    }

    @Override
    public void write(int c) {
        this.buf[0] = (char)c;
        this.write(this.buf, 0, 1);
    }

    @Override
    public void write(String str) {
        try {
            this.app.append(str);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            this.app.append(str, off, len - off);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        try {
            if (csq == null) {
                this.app.append("null");
            } else {
                this.app.append(csq, start, end);
            }
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void write(char[] paramArrayOfChar, int paramInt1, int paramInt2) {
        try {
            this.app.append(new String(paramArrayOfChar, paramInt1, paramInt2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(char[] paramArrayOfChar) {
        try {
            this.app.append(new String(paramArrayOfChar));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void newLine() {
        this.write(this.lineSeparator);
        if (this.autoFlush) {
            this.flush();
        }
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(String.valueOf(x));
        this.println();
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        this.formatter.format(Locale.getDefault(), format, args);
        if (this.autoFlush) {
            this.flush();
        }
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        this.formatter.format(l, format, args);
        if (this.autoFlush) {
            this.flush();
        }
        return this;
    }

    public static AppendableLocklessWriter asNewLineDispatcher(final SimplePublish1<String> newLine) {
        return new AppendableLocklessWriter(new Appendable(){
            protected StringBuilder sb = new StringBuilder();

            protected void dispatchLines() {
                int last;
                while ((last = this.sb.indexOf("\n")) != -1) {
                    String pub = this.sb.substring(0, last);
                    this.sb.delete(0, last + 1);
                    newLine.publish(pub);
                }
                return;
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                this.sb.append(csq, start, end);
                this.dispatchLines();
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                this.sb.append(c);
                this.dispatchLines();
                return this;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                this.sb.append(csq);
                this.dispatchLines();
                return this;
            }
        });
    }
}

