/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.reflect.Mirror;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FileBasedSet
implements Set<String>,
Closeable {
    protected final File file;
    protected final RandomAccessFile rw;
    protected final Set<String> content = new HashSet<String>();
    protected final TreeMap<Integer, List<FileRegion>> values = new TreeMap();
    protected final TreeMap<Integer, List<FileRegion>> free = new TreeMap();

    public FileBasedSet(File f) throws IOException {
        this.file = f;
        if (f.isDirectory()) {
            throw new RuntimeException("Given file is a directory: " + f);
        }
        this.rw = new RandomAccessFile(this.file, "rw");
        this.readFile();
        for (List<FileRegion> vs : this.values.values()) {
            for (FileRegion v : vs) {
                this.content.add(URLDecoder.decode(v.value));
            }
        }
    }

    public static List<FileRegion> getOfSize(Map<Integer, List<FileRegion>> map, int size) {
        return MapTools.getOrCreate(map, size, e -> new ArrayList());
    }

    protected void readFile() throws IOException {
        StringBuilder sb = new StringBuilder();
        long length = this.rw.length();
        long start = 0L;
        Boolean content = null;
        for (long i = 0L; i < length; ++i) {
            int val = this.rw.read();
            if (10 == val || val < 0) {
                if (null == content) {
                    if (val < 0) {
                        return;
                    }
                } else if (Boolean.FALSE == content) {
                    FileBasedSet.getOfSize(this.free, (int)(i - start)).add(new FileRegion(start, i - start, null));
                } else {
                    FileBasedSet.getOfSize(this.values, (int)(i - start)).add(new FileRegion(start, i - start, sb.toString()));
                    sb.delete(0, sb.length());
                }
                content = null;
                continue;
            }
            if (null == content) {
                if (13 == val) {
                    start = i;
                    content = false;
                    continue;
                }
                if (10 == val) {
                    throw new RuntimeException("double empty space at " + i);
                }
                start = i;
                content = true;
                sb.append((char)val);
                continue;
            }
            if (Boolean.TRUE == content) {
                sb.append((char)val);
                continue;
            }
            if (13 == val) continue;
            throw new RuntimeException("invalid empty block at " + i);
        }
    }

    @Override
    public synchronized int size() {
        return this.content.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.content.contains(o);
    }

    @Override
    public synchronized Iterator<String> iterator() {
        return this.content.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.content.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.content.toArray(a);
    }

    @Override
    public synchronized boolean add(String e) {
        AssertArgument.assertNotNull(e, "value");
        if (this.content.add(e)) {
            String fc = URLEncoder.encode(e);
            int len = fc.length();
            try {
                FileRegion reg = new FileRegion(Math.max(0L, this.rw.length()), len, fc);
                FileBasedSet.getOfSize(this.values, len).add(reg);
                reg.override(this.rw, fc.getBytes());
                this.rw.write(10);
            }
            catch (IOException e1) {
                Mirror.propagateAnyway(e1);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(Object o) {
        AssertArgument.assertNotNull(o, "value");
        if (this.content.remove(o)) {
            String fc = URLEncoder.encode(o.toString());
            int size = fc.getBytes().length;
            List<FileRegion> frs = this.values.get(size);
            for (FileRegion fr : frs) {
                if (!fc.equals(fr.value)) continue;
                try {
                    fr.erase(this.rw);
                    frs.remove(fr);
                    fr.value = null;
                    FileBasedSet.getOfSize(this.free, size).add(fr);
                }
                catch (Exception e) {
                    Mirror.propagateAnyway(e);
                }
                return true;
            }
            throw new RuntimeException("Inconsistent removal: removed from the cache but not in the file: " + o);
        }
        return false;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.content.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean all = true;
        for (String string : c) {
            all &= this.add(string);
        }
        return all;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean all = true;
        for (String v : this.content) {
            if (c.contains(v)) continue;
            all &= this.remove(v);
        }
        return all;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean all = true;
        for (Object v : c) {
            all &= this.remove(v);
        }
        return all;
    }

    @Override
    public synchronized void clear() {
        try {
            this.content.clear();
            this.rw.setLength(0L);
            this.values.clear();
            this.free.clear();
        }
        catch (IOException e) {
            Mirror.propagateAnyway(e);
        }
    }

    public synchronized String toString() {
        return CollectionTools.toStringMultiline(this.content);
    }

    @Override
    public void close() throws IOException {
        this.rw.close();
    }

    protected static class FileRegion {
        long off;
        long size;
        String value;

        public FileRegion(long off, long size, String value) {
            this.off = off;
            this.size = size;
            this.value = value;
        }

        public void erase(RandomAccessFile rw) throws IOException {
            byte[] data = new byte[(int)this.size];
            int i = 0;
            while ((long)i < this.size) {
                data[i] = 13;
                ++i;
            }
            this.override(rw, data);
        }

        public void override(RandomAccessFile rw, byte[] data) throws IOException {
            if ((long)data.length != this.size) {
                throw new RuntimeException("Content size mismatch: (" + data.length + ") space for content: " + this.size);
            }
            rw.seek(this.off);
            rw.write(data);
        }
    }
}

