/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.fd;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.CloseSensitiveInputStream;
import eu.javaexperience.io.CloseSensitiveOutputStream;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.multithread.notify.WaitForSingleEvent;
import eu.javaexperience.reflect.Mirror;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class IOStreamFactory {
    public static final IOStreamServer NO_OP_SERVER_SOCKET = new IOStreamServer<IOStream>(){
        WaitForSingleEvent wait = new WaitForSingleEvent();

        @Override
        public void close() throws IOException {
            this.wait.evenOcurred();
        }

        @Override
        public IOStream accept() throws IOException {
            try {
                this.wait.waitForEvent();
            }
            catch (InterruptedException e) {
                Mirror.propagateAnyway(e);
            }
            return null;
        }
    };

    public static IOStream fromSocket(final Socket s) throws IOException {
        return new IOStream(){
            InputStream is;
            OutputStream os;
            {
                this.is = s.getInputStream();
                this.os = s.getOutputStream();
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public void close() {
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean isClosed() {
                return false;
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public String localAddress() {
                return s.getLocalAddress().toString();
            }

            @Override
            public String remoteAddress() {
                return s.getRemoteSocketAddress().toString();
            }
        };
    }

    public static IOStream fromFD(final FileDescriptor fd) {
        return new IOStream(){
            InputStream is;
            OutputStream os;
            {
                this.is = new FileInputStream(fd);
                this.os = new FileOutputStream(fd);
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }

            @Override
            public void close() {
                try {
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public boolean isClosed() {
                return false;
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public String localAddress() {
                return fd.toString();
            }

            @Override
            public String remoteAddress() {
                return fd.toString();
            }
        };
    }

    public static IOStream fromFile(final String s) throws FileNotFoundException {
        return new IOStream(){
            CloseSensitiveInputStream is;
            CloseSensitiveOutputStream os;
            {
                this.is = new CloseSensitiveInputStream(new FileInputStream(s));
                this.os = new CloseSensitiveOutputStream(new FileOutputStream(s));
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }

            @Override
            public void close() {
                try {
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public boolean isClosed() {
                return this.is.isClosed() || this.os.isClosed();
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public String localAddress() {
                return s;
            }

            @Override
            public String remoteAddress() {
                return s;
            }
        };
    }

    public static IOStream fromInAndOutputStream(final InputStream ins, final OutputStream outs) {
        return new IOStream(){
            InputStream is;
            OutputStream os;
            {
                this.is = ins;
                this.os = outs;
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }

            @Override
            public void close() {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public String localAddress() {
                return "";
            }

            @Override
            public String remoteAddress() {
                return "";
            }
        };
    }

    public static IOStreamServer<IOStream> fromServerSocket(final ServerSocket ss) {
        return new IOStreamServer<IOStream>(){

            @Override
            public void close() {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            protected Socket realAccept() throws IOException {
                return ss.accept();
            }

            @Override
            public IOStream accept() throws IOException {
                return IOStreamFactory.fromSocket(this.realAccept());
            }
        };
    }

    public static IOStreamServer<IOStream> fromServerSocket(final ServerSocket ss, final SimplePublish1<Socket> beforeReturn) {
        return new IOStreamServer<IOStream>(){

            @Override
            public void close() {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            protected Socket realAccept() throws IOException {
                return ss.accept();
            }

            @Override
            public IOStream accept() throws IOException {
                Socket ret = this.realAccept();
                if (null != beforeReturn) {
                    beforeReturn.publish(ret);
                }
                return IOStreamFactory.fromSocket(ret);
            }
        };
    }

    public static IOStreamServer<IOStream> fromServerSocket(final ServerSocket ss, final GetBy1<IOStream, Socket> wrap) {
        return new IOStreamServer<IOStream>(){

            @Override
            public void close() {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            protected Socket realAccept() throws IOException {
                return ss.accept();
            }

            @Override
            public IOStream accept() throws IOException {
                return (IOStream)wrap.getBy(this.realAccept());
            }
        };
    }

    public static IOStream gzipize(final IOStream sock) throws IOException {
        return new IOStream(){
            GZIPInputStream in = new GZIPInputStream(sock.getInputStream());
            GZIPOutputStream out = new GZIPOutputStream(sock.getOutputStream());

            @Override
            public InputStream getInputStream() {
                return this.in;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.out;
            }

            @Override
            public void close() {
                sock.close();
            }

            @Override
            public boolean isClosed() {
                return sock.isClosed();
            }

            @Override
            public void flush() throws IOException {
                this.out.flush();
            }

            @Override
            public String localAddress() {
                return "gz:" + sock.localAddress();
            }

            @Override
            public String remoteAddress() {
                return "gz:" + sock.remoteAddress();
            }
        };
    }

    public static IOStreamServer<IOStream> gzipize(final IOStreamServer<IOStream> srv) {
        return new IOStreamServer<IOStream>(){

            @Override
            public void close() {
                IOTools.silentClose(srv);
            }

            @Override
            public IOStream accept() throws IOException {
                return IOStreamFactory.gzipize(srv.accept());
            }
        };
    }

    public static IOStream gzipize(final IOStream sock, final int Deflater_level) throws IOException {
        return new IOStream(){
            GZIPInputStream in = null;
            GZIPOutputStream out = new GZIPOutputStream(sock.getOutputStream()){
                {
                    super(x0);
                    this.def.setLevel(Deflater_level);
                }
            };
            {
                this.in = new GZIPInputStream(sock.getInputStream());
            }

            @Override
            public InputStream getInputStream() {
                return this.in;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.out;
            }

            @Override
            public void close() {
                sock.close();
            }

            @Override
            public boolean isClosed() {
                return sock.isClosed();
            }

            @Override
            public void flush() throws IOException {
                this.out.flush();
            }

            @Override
            public String localAddress() {
                return "gz:" + sock.localAddress();
            }

            @Override
            public String remoteAddress() {
                return "gz:" + sock.remoteAddress();
            }
        };
    }

    public static IOStreamServer<IOStream> gzipize(final IOStreamServer<IOStream> srv, final int Deflater_level) {
        return new IOStreamServer<IOStream>(){

            @Override
            public void close() {
                IOTools.silentClose(srv);
            }

            @Override
            public IOStream accept() throws IOException {
                return IOStreamFactory.gzipize(srv.accept(), Deflater_level);
            }
        };
    }
}

