/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.file;

import eu.javaexperience.asserts.AssertArgument;
import java.io.File;
import java.io.IOException;

public abstract class FileReloadEntry<T> {
    protected final File file;
    protected long lastAccess = -1L;
    protected T thing;

    public static boolean needReload(long entryTime, long fileTime) {
        long currentTime = System.currentTimeMillis() / 1000L;
        return (fileTime /= 1000L) == currentTime || fileTime > (entryTime /= 1000L);
    }

    public FileReloadEntry(File f) {
        this.file = f;
        AssertArgument.assertNotNull(this.file, "file");
    }

    protected abstract T processFile(File var1) throws IOException;

    public synchronized T get() throws IOException {
        long lastmod = this.file.lastModified();
        if (FileReloadEntry.needReload(this.lastAccess, lastmod)) {
            this.thing = this.processFile(this.file);
            this.lastAccess = lastmod;
        }
        return this.thing;
    }
}

