/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.primitive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class LineReader {
    protected final Reader read;

    public LineReader(Reader read) {
        this.read = read;
    }

    public static String readLine(Reader reader, LineMode mode) throws IOException {
        StringBuilder ret = new StringBuilder();
        char[] buf = new char[1];
        block0 : switch (mode) {
            case Mac: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == '\n') break block0;
                        if (buf[0] == '\r') continue;
                        ret.append(buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || ret.length() != 0) break;
                return null;
            }
            case Unix: 
            case Windows: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == mode.le) break block0;
                        ret.append(buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || ret.length() != 0) break;
                return null;
            }
            default: {
                throw new IllegalArgumentException("No line mode");
            }
        }
        return ret.toString();
    }

    public static String readLine(InputStream reader, LineMode mode) throws IOException {
        StringBuilder ret = new StringBuilder();
        byte[] buf = new byte[1];
        block0 : switch (mode) {
            case Mac: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == 10) break block0;
                        if (buf[0] == 13) continue;
                        ret.append((char)buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || ret.length() != 0) break;
                return null;
            }
            case Unix: 
            case Windows: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == mode.le) break block0;
                        ret.append((char)buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || ret.length() != 0) break;
                return null;
            }
            default: {
                throw new IllegalArgumentException("No line mode given");
            }
        }
        return ret.toString();
    }

    public static byte[] readByteLine(InputStream reader, LineMode mode) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1];
        block0 : switch (mode) {
            case Mac: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == 10) break block0;
                        if (buf[0] == 13) continue;
                        out.write(buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || out.size() != 0) break;
                return null;
            }
            case Unix: 
            case Windows: {
                int re;
                while (true) {
                    if ((re = reader.read(buf)) == 1) {
                        if (buf[0] == mode.le) break block0;
                        out.write(buf[0]);
                        continue;
                    }
                    if (re < 1) break;
                }
                if (re >= 0 || out.size() != 0) break;
                return null;
            }
            default: {
                throw new IllegalArgumentException("No line mode given");
            }
        }
        return out.toByteArray();
    }

    public String readLine() throws IOException {
        return LineReader.readLine(this.read, LineMode.Unix);
    }

    public static enum LineMode {
        Unix('\n'),
        Windows('\r'),
        Mac('\u0000');

        private final char le;

        private LineMode(char c) {
            this.le = c;
        }
    }
}

