/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.locales;

import eu.javaexperience.locales.AvailableCurrency;
import eu.javaexperience.locales.Currency;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotNull;
import java.util.HashMap;
import java.util.Map;

public class CurrencyTools {
    public static Currency NULL_CURRENCY = new Currency(){

        @Override
        public String getIso4217Name() {
            return "NULL";
        }
    };
    protected static final Map<String, AvailableCurrency> WELL_KNOWN_CURRENCIES = new HashMap<String, AvailableCurrency>();

    @MayNotNull
    public static Currency getOrCreateCurrency(String name) {
        if (null == name) {
            return NULL_CURRENCY;
        }
        final String n = name.trim().toUpperCase();
        AvailableCurrency ret = WELL_KNOWN_CURRENCIES.get(n);
        if (null != ret) {
            return ret;
        }
        return new Currency(){

            @Override
            public String getIso4217Name() {
                return n;
            }

            public boolean equals(Object obj) {
                return CurrencyTools.equalsByCurrencyIso4217(this, obj);
            }
        };
    }

    public static boolean equalsByCurrencyIso4217(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (!(o1 instanceof Currency) || !(o2 instanceof Currency)) {
            return false;
        }
        Currency c1 = (Currency)o1;
        Currency c2 = (Currency)o2;
        return Mirror.equals(c1.getIso4217Name(), c2.getIso4217Name());
    }

    static {
        for (AvailableCurrency ac : AvailableCurrency.values()) {
            WELL_KNOWN_CURRENCIES.put(ac.getIso4217Name(), ac);
        }
    }
}

