/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.math;

import java.util.List;

public class MathTools {
    public static int clamp(int min, int value, int max) {
        if (max < min) {
            int tmp = min;
            min = max;
            max = tmp;
        }
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static boolean inRange(Number Reference2, Number Check, Number Range) {
        if (null == Reference2 || null == Check) {
            return false;
        }
        double range = 0.0;
        if (null != Range) {
            range = Range.doubleValue();
        }
        double ref = Reference2.doubleValue();
        double check = Check.doubleValue();
        return check - range <= ref && ref <= check + range;
    }

    public static boolean inRelativeRange(Number Reference2, Number Check, Number RangePercent) {
        if (null == Reference2 || null == Check) {
            return false;
        }
        double range = 0.0;
        double ref = Reference2.doubleValue();
        double check = Check.doubleValue();
        if (null != RangePercent) {
            range = RangePercent.doubleValue() * ref;
        }
        return check - range <= ref && ref <= check + range;
    }

    public static boolean inRange(long ref, long check, long range) {
        return check - range <= ref && ref <= check + range;
    }

    public static int getMax(int[] ids) {
        int ret = Integer.MIN_VALUE;
        for (int i = 0; i < ids.length; ++i) {
            int val = ids[i];
            if (ret >= val) continue;
            ret = val;
        }
        return ret;
    }

    public static Long getMaxLong(List<? extends Number> lst) {
        boolean assigned = false;
        long ret = 0L;
        for (Number number : lst) {
            if (null == number) continue;
            if (!assigned) {
                ret = number.longValue();
                assigned = true;
                continue;
            }
            long l = number.longValue();
            if (ret >= l) continue;
            ret = l;
        }
        return assigned ? Long.valueOf(ret) : null;
    }

    public static double clamp(double min, double value, double max) {
        if (max < min) {
            double tmp = min;
            min = max;
            max = tmp;
        }
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static Double sawTeeth(double min, double step, double max, double val) {
        return MathTools.clamp(min, min + val * step % (max - min + 1.0), max);
    }

    public static int linearSawteethBetween(int min, int intValue, int max) {
        return MathTools.clamp(min, min + intValue % (max - min + 1), max);
    }

    public static int randomBetween(int min, int max) {
        return (int)((double)min + Math.random() * (double)(max - min));
    }
}

