/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.multithread.MultithreadingTools;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public abstract class RerunnableThread<T> {
    private volatile boolean free = true;
    private final Object mutex = new Object();
    protected final Semaphore semaphore = new Semaphore(0);
    protected volatile T param = null;
    private volatile boolean needwait = true;
    protected volatile long lastUsed = 0L;
    private final Thread worker = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = RerunnableThread.this.mutex;
                synchronized (object) {
                    if (RerunnableThread.this.needwait) {
                        try {
                            RerunnableThread.this.semaphore.acquire();
                            RerunnableThread.this.free = false;
                            RerunnableThread.this.needwait = true;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                try {
                    RerunnableThread.this.runThis(RerunnableThread.this.param);
                }
                catch (Throwable e) {
                    if (e == POISON) {
                        return;
                    }
                    System.err.println("TOPLEVEL UNCATCHED EXCEPTION");
                    e.printStackTrace();
                    try {
                        if (RerunnableThread.this.onException != null) {
                            RerunnableThread.this.onException.publish(RerunnableThread.this, e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                RerunnableThread.this.free = true;
                RerunnableThread.this.needwait = true;
                RerunnableThread.this.notifyFree();
            }
        }
    };
    public PrintStream errStream;
    public static final Error POISON = MultithreadingTools.THREAD_SHUTDOWN_POISON;
    protected Set<SimplePublish1<RerunnableThread<T>>> releaseListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected SimplePublish2<RerunnableThread<T>, Throwable> onException = null;

    protected void init() {
        this.free = true;
        this.needwait = true;
    }

    public RerunnableThread(boolean daemon) {
        this.worker.setDaemon(daemon);
        this.worker.start();
    }

    public synchronized void resetIfNeed() {
        if (!this.worker.isAlive() || this.worker.isInterrupted()) {
            this.init();
            this.worker.start();
        }
    }

    public StackTraceElement[] getStackTraceElements() {
        return this.worker.getStackTrace();
    }

    public RerunnableThread() {
        this.worker.start();
    }

    protected void stopCallerThread() {
        throw POISON;
    }

    public boolean isDaemon() {
        return this.worker.isDaemon();
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rerunWithParam(T param) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.free) {
                throw new IllegalStateException("ReuseableThread is in progress, not on rerun point, cannot rerun!");
            }
            this.needwait = false;
            this.free = false;
            this.param = param;
            this.lastUsed = System.currentTimeMillis();
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rerunIfFreeWithParam(T param) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isFree()) {
                return false;
            }
            this.rerunWithParam(param);
            return true;
        }
    }

    public boolean isFree() {
        return this.free;
    }

    public T getParam() {
        return this.param;
    }

    public abstract void runThis(T var1) throws Throwable;

    private void notifyFree() {
        for (SimplePublish1<RerunnableThread<T>> pub : this.releaseListeners) {
            try {
                pub.publish(this);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean registerReleaseListener(SimplePublish1<RerunnableThread<T>> pub) {
        AssertArgument.assertNotNull(pub, "release listener");
        return this.releaseListeners.add(pub);
    }

    public boolean unregisterReleaseListener(SimplePublish1<RerunnableThread<T>> pub) {
        AssertArgument.assertNotNull(pub, "release listener");
        return this.releaseListeners.remove(pub);
    }

    public boolean isReleaseListenerRegistered(SimplePublish1<RerunnableThread<T>> pub) {
        AssertArgument.assertNotNull(pub, "release listener");
        return this.releaseListeners.contains(pub);
    }

    public void finalize() {
        this.worker.interrupt();
    }
}

