/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.multithread.BlockingJob;
import eu.javaexperience.multithread.ScalableThreadpool;
import eu.javaexperience.multithread.ScalableThreadpoolManageStrategy;

public abstract class ScalableBlockingJobExecutor<T> {
    protected ScalableThreadpoolManageStrategy poolStrategy;
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("ScalableBlockingJobExecutor"));
    protected ScalableThreadpool<SimpleGet<BlockingJob<T>>> threadPool = new ScalableThreadpool(new SimpleGet<BlockingJob<T>>(){

        @Override
        public BlockingJob<T> get() {
            return ScalableBlockingJobExecutor.this.blockingJob;
        }
    });
    protected BlockingJob<T> blockingJob;

    public ScalableBlockingJobExecutor(ScalableThreadpoolManageStrategy poolStrategy) {
        this.poolStrategy = poolStrategy;
        AssertArgument.assertNotNull(this.poolStrategy, "poolStrategy");
    }

    public ScalableBlockingJobExecutor(int initialWorketCount) {
        this.poolStrategy = ScalableBlockingJobExecutor.getDefault(initialWorketCount);
    }

    @Deprecated
    public ScalableThreadpool<SimpleGet<BlockingJob<T>>> getThreadPool() {
        return this.threadPool;
    }

    public ScalableThreadpoolManageStrategy getStrategy() {
        return this.poolStrategy;
    }

    protected abstract BlockingJob<T> initalizeJob();

    public void start() {
        this.blockingJob = this.initalizeJob();
        AssertArgument.assertNotNull(this.blockingJob, "blockingJob");
        this.poolStrategy.initialize(this.threadPool);
        this.threadPool.start();
    }

    protected void manageLoad() {
        this.poolStrategy.manageLoad(this.threadPool);
    }

    public void setPoolStrategy(ScalableThreadpoolManageStrategy poolStrategy) {
        this.poolStrategy = poolStrategy;
    }

    public static ScalableThreadpoolManageStrategy getDefault(int initialWorkerCount) {
        return ScalableBlockingJobExecutor.getDefault(initialWorkerCount, 0.15, 0.75, 0.4);
    }

    public static ScalableThreadpoolManageStrategy getDefault(final int initialWorkerCount, final double shrinkLoad, final double growLoad, final double targetLoad) {
        return new ScalableThreadpoolManageStrategy(){

            @Override
            public void manageLoad(ScalableThreadpool<?> pool) {
                double num = pool.getNumberOfWorkers();
                double busy = pool.getNumberOfWorkingWorkers();
                double load = busy / num;
                if (load >= growLoad || load <= shrinkLoad) {
                    this.handle(pool);
                }
            }

            public void handle(ScalableThreadpool<?> pool) {
                int num = pool.getNumberOfWorkers();
                int busy = pool.getNumberOfWorkingWorkers();
                double load = (double)busy / (double)num;
                int newCount = num;
                if (load >= growLoad || load <= shrinkLoad) {
                    newCount = (int)((double)busy * (1.0 / targetLoad));
                }
                if (newCount < initialWorkerCount) {
                    newCount = initialWorkerCount;
                }
                if (num == newCount) {
                    return;
                }
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.INFO, "Scaling pool: threads: %d, busy: %d, newThreadCount: %d", (Object)num, (Object)busy, (Object)newCount);
                try {
                    pool.setWorkerCount(newCount);
                }
                catch (InterruptedException e) {
                    LoggingTools.tryLogSimple(LOG, (LoggingDetailLevel)LogLevel.WARNING, e);
                }
            }

            @Override
            public void initialize(ScalableThreadpool<?> pool) {
                pool.setNumberOfWorkers(initialWorkerCount);
            }
        };
    }

    public void stop() {
        this.threadPool.stop();
    }
}

