/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread.notify;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.reflect.Mirror;

public class WaitForEvents
implements SimpleCall {
    private Object waitLock = new Object();
    private Object nextWaitLock = new Object();
    private int numRequired = 0;
    private int numActual = 0;

    public WaitForEvents(int num) {
        this.numRequired = num;
    }

    public synchronized void resetCounter() {
        this.numActual = 0;
    }

    public synchronized int getTargetEventsNumber() {
        return this.numRequired;
    }

    public synchronized int getCurrentEventsNumbers() {
        return this.numActual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endWait() {
        this.numActual = Integer.MAX_VALUE;
        Object object = this.nextWaitLock;
        synchronized (object) {
            this.nextWaitLock.notifyAll();
        }
        object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void inc() {
        Object object = this.nextWaitLock;
        synchronized (object) {
            ++this.numActual;
            this.nextWaitLock.notifyAll();
            if (this.numActual == this.numRequired) {
                Object object2 = this.waitLock;
                synchronized (object2) {
                    this.waitLock.notifyAll();
                }
            }
        }
    }

    public void waitForAllEvent() {
        this.waitForAllEvent(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllEvent(long msTimeout) {
        Object object = this.waitLock;
        synchronized (object) {
            try {
                while (this.numActual < this.numRequired) {
                    this.waitLock.wait(msTimeout);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void waitForNextEvent() {
        this.waitForNextEvent(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextEvent(long msTimeout) {
        Object object = this.nextWaitLock;
        synchronized (object) {
            try {
                this.nextWaitLock.wait(msTimeout);
            }
            catch (Exception e) {
                Mirror.propagateAnyway(e);
            }
        }
    }

    @Override
    public void call() {
        this.inc();
    }
}

