/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.behavioral.cor;

import eu.javaexperience.collection.list.RWArrayList;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.dispatch.DispatcherTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.patterns.behavioral.cor.CorDispatcher;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.patterns.behavioral.cor.link.RuleChainLink;

public class CorChain<CTX>
implements Dispatcher<CTX> {
    protected CorDispatcher<CTX> ownerUnit;
    protected final String chainName;
    protected Dispatcher<CTX> defaultAction;
    protected RWArrayList<CorChainLink<CTX>> links = new RWArrayList();
    protected static Error EXIT_CHAIN_EXCEPTION = new Error("Exit Chain Exception");
    protected static Error EXIT_CHAIN_DISPATCHED_EXCEPTION = new Error("Exit Chain Dispatched Exception");
    protected static Error EXIT_CHAIN_DEFAULT_EXCEPTION = new Error("Exit Chain Default Exception");

    public CorChain(String name) {
        this.chainName = name;
    }

    public void setDefaultAction(Dispatcher<CTX> act) {
        this.defaultAction = act;
    }

    public boolean addLink(CorChainLink<CTX> link) {
        if (null == link) {
            return false;
        }
        this.links.add(link);
        link.setOwner(this);
        return true;
    }

    public boolean addLinkFromClosures(GetBy1<Boolean, CTX> checker, SimplePublish1<CTX> actor) {
        return this.addLink(new RuleChainLink<CTX>(checker, actor));
    }

    public boolean addSubDispatch(GetBy1<Boolean, CTX> checker, Dispatcher<CTX> actor) {
        return this.addLink(new RuleChainLink<CTX>(checker, DispatcherTools.toSimplePublish(actor)));
    }

    @Override
    public boolean dispatch(CTX ctx) {
        Dispatcher<CTX> def;
        block7: {
            if (!this.links.isEmpty()) {
                try {
                    for (CorChainLink<CTX> link : this.links) {
                        if (!link.dispatch(ctx)) continue;
                        return true;
                    }
                }
                catch (Error e) {
                    if (EXIT_CHAIN_DISPATCHED_EXCEPTION == e) {
                        return true;
                    }
                    if (EXIT_CHAIN_EXCEPTION == e) {
                        return false;
                    }
                    if (EXIT_CHAIN_DEFAULT_EXCEPTION == e) break block7;
                    throw e;
                }
            }
        }
        if (null != (def = this.defaultAction)) {
            return def.dispatch(ctx);
        }
        return false;
    }

    public void exitChain() {
        throw EXIT_CHAIN_EXCEPTION;
    }

    public void exitChainDefault() {
        throw EXIT_CHAIN_DEFAULT_EXCEPTION;
    }

    public void exitChainSuccessfullyDispatched() {
        throw EXIT_CHAIN_DISPATCHED_EXCEPTION;
    }

    public boolean includeChain(CTX ctx, String chain) {
        CorChain<CTX> cc;
        CorDispatcher<CTX> d = this.ownerUnit;
        if (null != d && null != (cc = d.getChainByName(chain))) {
            cc.dispatch(ctx);
            return true;
        }
        return false;
    }

    public void jumpToChain(CTX ctx, String chain) {
        CorChain<CTX> cc;
        CorDispatcher<CTX> d = this.ownerUnit;
        if (null != d && null != (cc = d.getChainByName(chain)) && cc.dispatch(ctx)) {
            this.exitChainSuccessfullyDispatched();
        }
        this.exitChain();
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setDefaultActionFromClosure(SimplePublish1<CTX> act) {
        this.defaultAction = DispatcherTools.toDispatcher(act);
    }

    public boolean addLinkAsFirst(CorChainLink<CTX> link) {
        if (null == link) {
            return false;
        }
        this.links.add(0, link);
        link.setOwner(this);
        return true;
    }
}

