/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.reflect;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.PrimitiveTools;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Mirror {
    public static final Object undefined = new Object();
    public static char[] emptyCharArray = new char[0];
    public static final Class<?>[] emptyClassArray = new Class[0];
    public static final int[] emptyIntArray = new int[0];
    public static final int[][] emptyIntIntArray = new int[0][0];
    public static final byte[] emptyByteArray = new byte[0];
    public static final long[] emptyNLongArray = new long[0];
    public static final Integer[] emptyIntegerArray = new Integer[0];
    public static final Method[] emptyMethodArray = new Method[0];
    public static final Field[] emptyFieldArray = new Field[0];
    public static final String[] emptyStringArray = new String[0];
    public static final String[][] emptyStringArrayArray = new String[0][0];
    public static final Object[] emptyObjectArray = new Object[0];
    public static final Boolean[] emptyBooleanArray = new Boolean[0];
    public static final Long[] emptyLongArray = new Long[0];
    public static final GetBy1<Object, Class<?>> SIMPLE_CREATOR = new GetBy1<Object, Class<?>>(){

        @Override
        public Object getBy(Class<?> a) {
            try {
                return a.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    protected static final int SHALLOW_EXCLUDE_MODIFIER = 136;

    private Mirror() {
    }

    public static <T> T tryCastOrNull(Object o, Class<T> cls) {
        if (o == null) {
            return null;
        }
        if (cls.isAssignableFrom(o.getClass())) {
            return cls.cast(o);
        }
        return null;
    }

    public static Object getObjectFieldOrNull(Object o, String field) {
        try {
            return Mirror.getClassFieldOrNull(o.getClass(), field).get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getObjectFieldByClassOrNull(Class cls, Object o, String field) {
        try {
            return Mirror.getClassFieldOrNull(cls, field).get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getObjectFieldByClassOrNull(String cls, Object o, String field) {
        try {
            return Mirror.getClassFieldOrNull(cls, field).get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getClassMethodOrNull(String cls, String method, Class<?> ... types) {
        try {
            Method ret = Class.forName(cls).getDeclaredMethod(method, types);
            Mirror.setAccessible(ret);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getClassFieldOrNull(String cls, String field) {
        try {
            Field ret = Class.forName(cls).getDeclaredField(field);
            Mirror.setAccessible(ret);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getClassMethodOrNull(Class<?> cls, String method, Class<?> ... types) {
        try {
            Method ret = cls.getDeclaredMethod(method, types);
            Mirror.setAccessible(ret);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getClassUniqueNameMethodOrNull(Class<?> cls, String method) {
        try {
            Method[] mets;
            for (Method m : mets = cls.getDeclaredMethods()) {
                if (!method.equals(m.getName())) continue;
                Mirror.setAccessible(m);
                return m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Field getClassFieldOrNull(Class<?> cls, String field) {
        try {
            ClassData cd = Mirror.getClassData(cls);
            for (Field f : cd.getAllFields()) {
                if (!field.equals(f.getName())) continue;
                Mirror.setAccessible(f);
                return f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void var_dump_throw(Appendable ps, Object o, String c) throws IllegalArgumentException, IllegalAccessException, IOException {
        Mirror.var_dump(ps, o, 1, c, new ArrayList<Object>());
    }

    public static void var_dump(Appendable ps, Object o, String c) {
        try {
            Mirror.var_dump_throw(ps, o, c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassData getClassData(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ClassData ret = (ClassData)LazyClassDataInit.data.get(cls);
        if (ret == null) {
            ret = new ClassData(cls);
            LazyClassDataInit.data.put(cls, ret);
        }
        return ret;
    }

    public static ClassData getClassData(String scls) {
        Class<?> cls = null;
        try {
            cls = Class.forName(scls);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (cls == null) {
            return null;
        }
        ClassData ret = (ClassData)LazyClassDataInit.data.get(cls);
        if (ret == null) {
            ret = new ClassData(cls);
            LazyClassDataInit.data.put(cls, ret);
        }
        return ret;
    }

    public static void fillObjectPublicFieldIntoMap(Object o, Map<String, Object> map) throws IllegalArgumentException, IllegalAccessException {
        Field[] fs;
        ClassData dat = Mirror.getClassData(o.getClass());
        for (Field f : fs = dat.select(new FieldSelector(true, Visibility.Public, BelongTo.Instance, Select.All, Select.All, Select.All))) {
            map.put(f.getName(), f.get(o));
        }
    }

    public static void fillMapIntoObject(Map<String, Object> map, Object o) throws IllegalArgumentException, IllegalAccessException {
        Field[] fs;
        ClassData dat = Mirror.getClassData(o.getClass());
        for (Field f : fs = dat.select(new FieldSelector(true, Visibility.All, BelongTo.Instance, Select.All, Select.All, Select.All))) {
            if (!map.containsKey(f.getName())) continue;
            try {
                f.set(o, map.get(f.getName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void tryFillMapIntoObjectCast(Map<String, Object> map, Object o) {
        Field[] fs;
        ClassData dat = Mirror.getClassData(o.getClass());
        for (Field f : fs = dat.select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
            CastTo cast;
            if (!map.containsKey(f.getName()) || null == (cast = CastTo.getCasterRestrictlyForTargetClass(f.getType()))) continue;
            Object set = map.get(f.getName());
            set = cast.cast(set);
            try {
                f.set(o, set);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Number castNumberTo(Number n, Class<? extends Number> cls) {
        if ((cls = PrimitiveTools.translatePrimitiveToObjectType(cls)) == Integer.class) {
            return n.intValue();
        }
        if (cls == Long.class) {
            return n.longValue();
        }
        if (cls == Double.class) {
            return n.doubleValue();
        }
        if (cls == Float.class) {
            return Float.valueOf(n.floatValue());
        }
        if (cls == Byte.class) {
            return n.byteValue();
        }
        if (cls == Short.class) {
            return n.shortValue();
        }
        return n;
    }

    private static void var_dump(Appendable ps, Object obj, int lvl, String c, ArrayList<Object> disa) throws IllegalArgumentException, IllegalAccessException, IOException {
        if (obj == null) {
            ps.append("null,\n");
            return;
        }
        if (disa.contains(obj)) {
            ps.append("@[");
            ps.append(Integer.toHexString(obj.hashCode()));
            ps.append("]\n");
            return;
        }
        disa.add(obj);
        String ls = StringTools.repeatString(c, lvl - 1);
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            ps.append("<");
            Mirror.printClassType(ps, cls);
            ps.append("> ");
            ps.append(Integer.toHexString(System.identityHashCode(obj)));
            ps.append("\n");
            ps.append(ls);
            ps.append("{\n");
            for (int i = 0; i < Array.getLength(obj); ++i) {
                ps.append(ls);
                ps.append(c);
                ps.append("[");
                ps.append(String.valueOf(i));
                ps.append("] : ");
                Mirror.var_dump(ps, Array.get(obj, i), lvl + 1, c, disa);
            }
            ps.append(ls);
            ps.append("},\n");
        } else if (PrimitiveTools.isPrimitiveTypeObject(cls)) {
            ps.append("<");
            ps.append(cls.getName());
            ps.append(">");
            ps.append(" : ");
            ps.append(obj.toString());
            ps.append(",\n");
        } else if (cls.equals(String.class)) {
            ps.append("<");
            ps.append(cls.getName());
            ps.append(">");
            ps.append(" : ");
            ps.append("\"");
            ps.append(obj.toString());
            ps.append("\"");
            ps.append(",\n");
        } else {
            Field[] fields = Mirror.collectClassFields(cls, false);
            ps.append("<");
            Mirror.printClassType(ps, cls);
            ps.append("> ");
            ps.append(Integer.toHexString(System.identityHashCode(obj)));
            ps.append(":\n");
            ps.append(ls);
            ps.append("{\n");
            for (Field f : fields) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                ps.append(ls);
                ps.append(c);
                ps.append(f.getName());
                ps.append("(");
                Mirror.printClassType(ps, f.getType());
                ps.append(")");
                ps.append(" : ");
                f.setAccessible(true);
                Object val = f.get(obj);
                Mirror.var_dump(ps, val, lvl + 1, c, disa);
            }
            ps.append(ls);
            ps.append("},\n");
        }
    }

    public static Field[] collectClassFields(Class<?> cls, boolean publicOnly) {
        ArrayList<Field> l = new ArrayList<Field>();
        Mirror.collectClassFields(cls, l, publicOnly);
        return l.toArray(emptyFieldArray);
    }

    public static void collectClassFields(Class<?> cls, ArrayList<Field> ret, boolean publicOnly) {
        if (cls.isInterface() || cls == Object.class) {
            return;
        }
        for (Field f : publicOnly ? cls.getFields() : cls.getDeclaredFields()) {
            ret.add(f);
        }
        Class<?> sup = cls.getSuperclass();
        if (sup != null) {
            Mirror.collectClassFields(sup, ret, publicOnly);
        }
    }

    public static Method[] collectClassMethods(Class<?> cls, boolean publicOnly) {
        ArrayList<Method> l = new ArrayList<Method>();
        Mirror.collectClassMethods(cls, l, publicOnly);
        return l.toArray(emptyMethodArray);
    }

    public static void collectClassMethods(Class<?> cls, ArrayList<Method> ret, boolean publicOnly) {
        for (Method f : publicOnly ? cls.getMethods() : cls.getDeclaredMethods()) {
            ret.add(f);
        }
        Class<?> sup = cls.getSuperclass();
        if (sup != null) {
            Mirror.collectClassMethods(sup, ret, publicOnly);
        }
        for (Class<?> c : cls.getInterfaces()) {
            if (c == null) continue;
            Mirror.collectClassMethods(c, ret, publicOnly);
        }
    }

    public static Class<?> getFinalComponentClass(Class<?> cls) {
        if (cls.isArray()) {
            return Mirror.getFinalComponentClass(cls.getComponentType());
        }
        return cls;
    }

    public static int determineArrayDeep(Class<?> c) {
        return Mirror.determineArrayDeep(c, 0);
    }

    private static int determineArrayDeep(Class<?> c, int lvl) {
        if (!c.isArray()) {
            return lvl;
        }
        return Mirror.determineArrayDeep(c.getComponentType(), lvl + 1);
    }

    public static void printClassType(Appendable ps, Class<?> cls) throws IOException {
        int deep = Mirror.determineArrayDeep(cls);
        Class<?> comp = Mirror.getFinalComponentClass(cls);
        ps.append(comp.getName());
        for (int i = 0; i < deep; ++i) {
            ps.append("[]");
        }
    }

    public static void appendClassType(StringBuilder ps, Class<?> cls) {
        int deep = Mirror.determineArrayDeep(cls);
        Class<?> comp = Mirror.getFinalComponentClass(cls);
        ps.append(comp.getCanonicalName());
        for (int i = 0; i < deep; ++i) {
            ps.append("[]");
        }
    }

    public static String getClassTypeString(Class<?> cls) {
        StringBuilder sb = new StringBuilder();
        Mirror.appendClassType(sb, cls);
        return sb.toString();
    }

    public static Field setAccessible(Field f) {
        f.setAccessible(true);
        return f;
    }

    public static Method setAccessible(Method f) {
        f.setAccessible(true);
        return f;
    }

    public static Object newInstanceOrNull(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeClassMethod(Class<?> cls, String method, Object This) {
        Method m = Mirror.getClassMethodOrNull(cls, method, new Class[0]);
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(This, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeClassMethod(Object This, String method) {
        Method m = Mirror.getClassMethodOrNull(This.getClass(), method, new Class[0]);
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(This, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object invokeClassMethod(String scls, Object This, String method) {
        try {
            Class<?> cls = Mirror.getClassData((String)scls).cls;
            Method m = Mirror.getClassMethodOrNull(cls, method, new Class[0]);
            if (m == null) {
                return null;
            }
            return m.invoke(This, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getClassName(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        dis.readLong();
        int cpcnt = (dis.readShort() & 0xFFFF) - 1;
        int[] classes = new int[cpcnt];
        String[] strings = new String[cpcnt];
        for (int i = 0; i < cpcnt; ++i) {
            int t = dis.read();
            if (t == 7) {
                classes[i] = dis.readShort() & 0xFFFF;
                continue;
            }
            if (t == 1) {
                strings[i] = dis.readUTF();
                continue;
            }
            if (t == 5 || t == 6) {
                dis.readLong();
                ++i;
                continue;
            }
            if (t == 8) {
                dis.readShort();
                continue;
            }
            dis.readInt();
        }
        dis.readShort();
        return strings[classes[(dis.readShort() & 0xFFFF) - 1] - 1].replace('/', '.');
    }

    public static Object tryUnpack(Object o) {
        if (null == o) {
            return null;
        }
        if (o.getClass().isArray() && Array.getLength(o) > 0) {
            return Array.get(o, 0);
        }
        return o;
    }

    public static boolean in(int val, int ... vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean in(@MayNotNull Object val, Object ... vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (!val.equals(vals[i])) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void throwSoftOrHardButAnyway(Throwable t) {
        Mirror.propagateAnyway(t);
    }

    public static void propagateAnyway(Throwable t) {
        Throwable tmp;
        if (t instanceof InvocationTargetException && null != (tmp = ((InvocationTargetException)t).getCause())) {
            t = tmp;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static <T> T valueOrDefault(T value, T _default) {
        if (null != value) {
            return value;
        }
        return _default;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (null != o1) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int compare(int a, int b) {
        if (a > b) {
            return 1;
        }
        if (b > a) {
            return -1;
        }
        return 0;
    }

    public static <T> T shallowClone(T origin, Field[] toClone) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Object ret = origin.getClass().newInstance();
        Mirror.shallowClone(origin, ret, toClone);
        return (T)ret;
    }

    public static <T> void shallowClone(T origin, T newObject, Field[] toClone) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : toClone) {
            Object src = f.get(origin);
            f.set(newObject, src);
        }
    }

    protected static InputStream getResource(String relative) {
        HashSet<ClassLoader> cls = new HashSet<ClassLoader>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        do {
            InputStream is;
            if (null != (is = cl.getResourceAsStream(relative))) {
                return is;
            }
            if (cls.contains(cl)) {
                return null;
            }
            cls.add(cl);
        } while (null != (cl = cl.getParent()));
        return null;
    }

    public static byte[] getJavaResource(String relativePath) throws IOException {
        try (InputStream is = Mirror.getResource(relativePath);){
            if (null == is) {
                byte[] byArray = emptyByteArray;
                return byArray;
            }
            byte[] byArray = IOTools.loadAllFromInputStream(is);
            return byArray;
        }
    }

    public static byte[] getPackageResource(Class<?> cls, String string) throws IOException {
        String pack = StringTools.getSubstringBeforeLastString(StringTools.replaceAllStrings(cls.getCanonicalName(), ".", "/"), "/");
        return Mirror.getJavaResource(pack + "/" + string);
    }

    public static boolean isStatic(Member f) {
        int mod = f.getModifiers();
        return Modifier.isStatic(mod);
    }

    public static boolean isPublic(Member f) {
        int mod = f.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static Object clone(Object obj, GetBy1<Object, Class<?>> simpleCreator, GetBy2<Object, Field, Object> cloner) throws IllegalArgumentException, IllegalAccessException {
        Object ret = simpleCreator.getBy(obj.getClass());
        ClassData cd = Mirror.getClassData(obj.getClass());
        for (Field f : cd.all_fields) {
            if (Mirror.isStatic(f)) continue;
            f.set(ret, cloner.getBy(f, f.get(obj)));
        }
        return ret;
    }

    public static Object simpleShallowClone(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return Mirror.clone(obj, SIMPLE_CREATOR, CloningMethod.REFERENCE_ASSIGN);
    }

    public static void extractFieldsToMap(Object in, Map<String, Object> values, FieldSelector select) throws IllegalArgumentException, IllegalAccessException {
        Field[] fs;
        ClassData dat = Mirror.getClassData(in.getClass());
        for (Field f : fs = dat.select(select)) {
            values.put(f.getName(), f.get(in));
        }
    }

    public static Object tryGetFieldValue(Object o, String key) {
        if (null == o) {
            return null;
        }
        try {
            Class<?> c = o.getClass();
            Field f = c.getDeclaredField(key);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?> extracClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            return Array.newInstance(Mirror.extracClass(((GenericArrayType)t).getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            return Mirror.extracClass(((ParameterizedType)t).getRawType());
        }
        return Object.class;
    }

    public static boolean isVoid(Class cls) {
        if (null != cls) {
            return Void.TYPE == cls || Void.class == cls;
        }
        return false;
    }

    public static boolean shallowEquals(Object me, Object obj) {
        if (null == me || null == obj) {
            return false;
        }
        if (me == obj) {
            return true;
        }
        if (!me.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        Field[] fs = Mirror.getClassData(me.getClass()).self_fields;
        try {
            for (Field f : fs) {
                if (0 != (f.getModifiers() & 0x88) || Mirror.equals(f.get(me), f.get(obj))) continue;
                return false;
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
        return true;
    }

    public static int shallowHashCode(Object me) {
        if (null == me) {
            return 0;
        }
        int ret = 27;
        Field[] fs = Mirror.getClassData(me.getClass()).self_fields;
        try {
            for (Field f : fs) {
                if (0 != (f.getModifiers() & 0x88)) continue;
                int ph = 0;
                Object o = f.get(me);
                if (null != o) {
                    ph = o.hashCode();
                }
                ret = 31 * ret + ph;
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
        return ret;
    }

    public static URL getClassUrl(Class<?> cls) {
        String file = StringTools.replaceAllStrings(cls.getName(), ".", "/") + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytecode(Class<?> cls) throws IOException {
        String file = StringTools.replaceAllStrings(cls.getName(), ".", "/") + ".class";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (null != is) {
            try {
                byte[] byArray = IOTools.loadAllFromInputStream(is);
                return byArray;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    public static void setProperty(Object subject, String field, Object value) throws IllegalArgumentException, IllegalAccessException {
        ClassData cd = Mirror.getClassData(subject.getClass());
        for (Field f : cd.getAllFields()) {
            if (!f.getName().equals(field)) continue;
            f.set(subject, value);
        }
    }

    public static <T> T passOnlyInstanceOf(Class<T> cls, Object object) {
        if (null != object && cls.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return null;
    }

    public static boolean isRestAppicableForType(Class forClass, int startIndexInclusive, boolean mayNull, Class ... inputClasses) {
        for (int i = startIndexInclusive; i < inputClasses.length; ++i) {
            Class c = inputClasses[i];
            if (!(null == c ? !mayNull : !forClass.isAssignableFrom(c))) continue;
            return false;
        }
        return true;
    }

    public static <T> Object[] varargize(Class<T> reqClass, int startIndexInclusiveDst, Object ... params) {
        int i;
        Object[] varargs = (Object[])Array.newInstance(reqClass, params.length - startIndexInclusiveDst);
        Object[] ret = new Object[startIndexInclusiveDst + 1];
        for (i = 0; i <= startIndexInclusiveDst; ++i) {
            ret[i] = params[i];
        }
        ret[startIndexInclusiveDst] = varargs;
        for (i = 0; i < varargs.length; ++i) {
            varargs[i] = params[startIndexInclusiveDst + i];
        }
        return ret;
    }

    public static <T> Class[] getClasses(T[] arr) {
        Class[] ret = new Class[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            T o = arr[i];
            ret[i] = null == o ? null : o.getClass();
        }
        return ret;
    }

    public static Object callMethod(Object subject, String method, Object ... params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] obj = new Class[params.length];
        ClassData cd = Mirror.getClassData(subject.getClass());
        Method func = null;
        Class[] pclasses = Mirror.getClasses(params);
        for (Method m : cd.all_methods) {
            if (Mirror.isStatic(m) || !method.equals(m.getName())) continue;
            Object[] ps = m.getParameterTypes();
            if (ps.length < params.length) {
                throw new RuntimeException("Parameter count mismatch: req_params:" + Arrays.toString(ps) + ", given: " + pclasses);
            }
            if (ps.length > params.length) {
                if (!Mirror.isRestAppicableForType((Class)ps[ps.length - 1], ps.length - 1, true, pclasses)) {
                    throw new RuntimeException("Can't varargize parameters: req_params:" + Arrays.toString(ps) + ", given: " + pclasses);
                }
                params = Mirror.varargize(ps[ps.length - 1], ps.length - 1, params);
            }
            for (int i = 0; i < ps.length; ++i) {
                Object fc = ps[i];
                Class pc = pclasses[i];
                if (null == pc || ((Class)fc).isAssignableFrom(pc)) continue;
                throw new RuntimeException("Invalid argument type: req: " + fc + " given: " + pc);
            }
            func = m;
            break;
        }
        if (null == func) {
            throw new RuntimeException("Method (\"" + method + "\") not found in :" + subject.getClass());
        }
        return func.invoke(subject, params);
    }

    public static <T> boolean trySetObjectField(Class<T> cls, T instance, String field, Object value) {
        try {
            Field ret = cls.getDeclaredField(field);
            Mirror.setAccessible(ret);
            ret.set(instance, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String usualToString(Object obj) {
        ClassData cd = Mirror.getClassData(obj.getClass());
        Field[] fs = cd.selectFields(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD);
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        sb.append(": {");
        boolean hasOut = false;
        for (Field f : fs) {
            Class<?> ft = f.getType();
            if (hasOut) {
                sb.append(", ");
            }
            sb.append(f.getName());
            sb.append(": ");
            try {
                Object o = f.get(obj);
                if (null == o) {
                    sb.append("null");
                } else if (Collection.class.isAssignableFrom(o.getClass())) {
                    sb.append(CollectionTools.toString((Collection)o));
                } else if (Map.class.isAssignableFrom(o.getClass())) {
                    sb.append(MapTools.toString((Map)o));
                } else if (Date.class.isAssignableFrom(o.getClass())) {
                    sb.append(Format.UTC_SQL_TIMESTAMP_MS.format((Date)o));
                } else {
                    sb.append(o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hasOut = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> class1, Class ... params) {
        try {
            Constructor<T> ret = class1.getDeclaredConstructor(params);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<Socket> class1, String name, Class ... params) {
        try {
            Method ret = class1.getDeclaredMethod(name, params);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
            return null;
        }
    }

    public static enum CloningMethod implements GetBy2<Object, Field, Object>
    {
        SKIP{

            @Override
            public Object getBy(Field a, Object b) {
                return null;
            }
        }
        ,
        REFERENCE_ASSIGN{

            @Override
            public Object getBy(Field a, Object b) {
                return b;
            }
        }
        ,
        DEEP_COPY{

            @Override
            public Object getBy(Field a, Object b) {
                try {
                    return Mirror.clone(b, SIMPLE_CREATOR, DEEP_COPY);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };

    }

    public static class ClassData {
        final Class<?> cls;
        final Method[] self_methods;
        final Method[] all_methods;
        final Field[] self_fields;
        final Field[] all_fields;
        final Class<?>[] direct_interfaces;
        final Class<?>[] all_interfaces;
        final Class<?> direct_superclass;
        final Class<?>[] all_superclass;
        ConcurrentMap<MethodSelector, Method[]> metSel = new ConcurrentHashMap<MethodSelector, Method[]>();
        ConcurrentMap<FieldSelector, Field[]> fieldSel = new ConcurrentHashMap<FieldSelector, Field[]>();

        /*
         * WARNING - void declaration
         */
        private ClassData(@MayNotNull Class<?> cls) {
            this.cls = cls;
            this.self_methods = cls.getDeclaredMethods();
            this.self_fields = cls.getDeclaredFields();
            this.direct_interfaces = cls.getInterfaces();
            this.direct_superclass = cls.getSuperclass();
            Class<?>[] interf = this.direct_interfaces;
            if (this.direct_superclass != null) {
                void var6_8;
                ClassData dat = Mirror.getClassData(this.direct_superclass);
                this.all_methods = ArrayTools.arrayConcat(this.self_methods, dat.all_methods);
                this.all_fields = ArrayTools.arrayConcat(this.self_fields, dat.all_fields);
                Class<?>[] classArray = this.direct_interfaces;
                int n = classArray.length;
                boolean i = false;
                while (var6_8 < n) {
                    Class<?> in = classArray[var6_8];
                    interf = ArrayTools.arrayConcat(interf, Mirror.getClassData(in).all_interfaces);
                    ++var6_8;
                }
                this.all_superclass = ArrayTools.arrayAppend(this.direct_superclass, dat.all_superclass);
            } else {
                this.all_methods = this.self_methods;
                this.all_fields = this.self_fields;
                this.all_superclass = emptyClassArray;
            }
            for (Field field : this.self_fields) {
                Mirror.setAccessible(field);
            }
            for (AccessibleObject accessibleObject : this.self_methods) {
                Mirror.setAccessible((Method)accessibleObject);
            }
            this.all_interfaces = interf;
        }

        public Class<?> getSubjectClass() {
            return this.cls;
        }

        public Method[] getSelfMethods() {
            return ArrayTools.copy(this.self_methods);
        }

        public Method[] getAllMethods() {
            return ArrayTools.copy(this.all_methods);
        }

        public Field[] getSelfFields() {
            return ArrayTools.copy(this.self_fields);
        }

        public Field[] getAllFields() {
            return ArrayTools.copy(this.all_fields);
        }

        public Method[] selectMethods(MethodSelector sel) {
            Method[] ret = (Method[])this.metSel.get(sel);
            if (ret == null) {
                ret = this.select(sel);
                this.metSel.put(sel, ret);
            }
            return ret;
        }

        public Field[] selectFields(FieldSelector sel) {
            Field[] ret = (Field[])this.fieldSel.get(sel);
            if (ret == null) {
                ret = this.select(sel);
                this.fieldSel.put(sel, ret);
            }
            return ret;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Method[] select(MethodSelector sel) {
            Method[] ms;
            ArrayList<Method> met = new ArrayList<Method>();
            Method[] methodArray = ms = sel.all ? this.all_methods : this.self_methods;
            int n = methodArray.length;
            int n2 = 0;
            while (true) {
                block13: {
                    if (n2 >= n) {
                        return met.toArray(emptyMethodArray);
                    }
                    Method m = methodArray[n2];
                    int mod = m.getModifiers();
                    switch (sel.vis) {
                        case Default: {
                            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod) && !Modifier.isPrivate(mod)) break;
                            break block13;
                        }
                        case Private: {
                            if (Modifier.isPrivate(mod)) break;
                            break block13;
                        }
                        case Protected: {
                            if (Modifier.isProtected(mod)) break;
                            break block13;
                        }
                        case Public: {
                            if (!Modifier.isPublic(mod)) break block13;
                        }
                    }
                    switch (sel.belong) {
                        case Instance: {
                            if (!Modifier.isStatic(mod)) break;
                            break block13;
                        }
                        case Static: {
                            if (!Modifier.isStatic(mod)) break block13;
                        }
                    }
                    if (!(ClassData.acceptByMatch(1024, sel._abstract, mod) || ClassData.acceptByMatch(16, sel._final, mod) || ClassData.acceptByMatch(32, sel._synchronized, mod) || ClassData.acceptByMatch(256, sel._native, mod) || ClassData.acceptByMatch(2048, sel._strict, mod))) {
                        met.add(m);
                    }
                }
                ++n2;
            }
        }

        public static boolean acceptByMatch(int modifier, Select sel, int value) {
            switch (sel) {
                case Is: {
                    return (modifier & value) != modifier;
                }
                case IsNot: {
                    return (modifier & value) != 0;
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Field[] select(FieldSelector sel) {
            Field[] ms;
            ArrayList<Field> met = new ArrayList<Field>();
            Field[] fieldArray = ms = sel.all ? this.all_fields : this.self_fields;
            int n = fieldArray.length;
            int n2 = 0;
            while (true) {
                block13: {
                    if (n2 >= n) {
                        return met.toArray(emptyFieldArray);
                    }
                    Field f = fieldArray[n2];
                    int mod = f.getModifiers();
                    switch (sel.vis) {
                        case Default: {
                            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod) && !Modifier.isPrivate(mod)) break;
                            break block13;
                        }
                        case Private: {
                            if (Modifier.isPrivate(mod)) break;
                            break block13;
                        }
                        case Protected: {
                            if (Modifier.isProtected(mod)) break;
                            break block13;
                        }
                        case Public: {
                            if (!Modifier.isPublic(mod)) break block13;
                        }
                    }
                    switch (sel.belong) {
                        case Instance: {
                            if (!Modifier.isStatic(mod)) break;
                            break block13;
                        }
                        case Static: {
                            if (!Modifier.isStatic(mod)) break block13;
                        }
                    }
                    if (!(ClassData.acceptByMatch(128, sel._transient, mod) || ClassData.acceptByMatch(16, sel._final, mod) || ClassData.acceptByMatch(64, sel._volatile, mod))) {
                        met.add(f);
                    }
                }
                ++n2;
            }
        }

        public Field getFieldByName(String k) {
            for (Field f : this.getAllFields()) {
                if (!f.getName().equals(k)) continue;
                return f;
            }
            return null;
        }

        public void addClassesAndIntefaces(Collection<Class> dst) {
            dst.add(this.cls);
            CollectionTools.inlineAdd(dst, this.all_superclass);
            CollectionTools.inlineAdd(dst, this.all_interfaces);
        }

        public Class[] getAllSuperClassAndInterfaces() {
            ArrayList<Class> ret = new ArrayList<Class>();
            this.addClassesAndIntefaces(ret);
            return ret.toArray(emptyClassArray);
        }
    }

    public static final class FieldSelector {
        final boolean all;
        final Visibility vis;
        final BelongTo belong;
        final Select _final;
        final Select _transient;
        final Select _volatile;

        public FieldSelector(boolean all_not_just_self, Visibility visibility, BelongTo belong, Select _final, Select _transient, Select _volatile) {
            this.all = all_not_just_self;
            this.vis = visibility;
            this.belong = belong;
            this._final = _final;
            this._transient = _transient;
            this._volatile = _volatile;
        }

        public int hashCode() {
            int ret = 0;
            ret &= this.all ? 1 : 0;
            ret &= this.vis.ordinal() >> 1;
            ret &= this.belong.ordinal() >> 4;
            ret &= this._transient.ordinal() >> 6;
            ret &= this._final.ordinal() >> 8;
            return ret &= this._volatile.ordinal() >> 10;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldSelector)) {
                return false;
            }
            FieldSelector dat = (FieldSelector)o;
            return this.all == dat.all && this.vis == dat.vis && this.belong == dat.belong && this._transient == dat._transient && this._final == dat._final && this._volatile == dat._volatile;
        }
    }

    public static final class MethodSelector {
        final boolean all;
        final Visibility vis;
        final BelongTo belong;
        final Select _abstract;
        final Select _final;
        final Select _synchronized;
        final Select _native;
        final Select _strict;

        public MethodSelector(boolean all_not_just_self, Visibility visibility, BelongTo belong, Select _abstract, Select _final, Select _synchronized, Select _native, Select _strict) {
            this.all = all_not_just_self;
            this.vis = visibility;
            this.belong = belong;
            this._abstract = _abstract;
            this._final = _final;
            this._synchronized = _synchronized;
            this._native = _native;
            this._strict = _strict;
        }

        public int hashCode() {
            int ret = 0;
            ret &= this.all ? 1 : 0;
            ret &= this.vis.ordinal() >> 1;
            ret &= this.belong.ordinal() >> 4;
            ret &= this._abstract.ordinal() >> 6;
            ret &= this._final.ordinal() >> 8;
            ret &= this._synchronized.ordinal() >> 10;
            ret &= this._native.ordinal() >> 12;
            return ret &= this._strict.ordinal() >> 14;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSelector)) {
                return false;
            }
            MethodSelector dat = (MethodSelector)o;
            return this.all == dat.all && this.vis == dat.vis && this.belong == dat.belong && this._abstract == dat._abstract && this._final == dat._final && this._synchronized == dat._synchronized && this._native == dat._native && this._strict == dat._strict;
        }
    }

    public static enum Select {
        All,
        Is,
        IsNot;

    }

    public static enum BelongTo {
        Any,
        Static,
        Instance;

    }

    public static enum Visibility {
        All,
        Default,
        Public,
        Protected,
        Private;

    }

    protected static class LazyClassDataInit {
        protected static ConcurrentMap<Class<?>, ClassData> data = new ConcurrentHashMap();

        protected LazyClassDataInit() {
        }
    }
}

