/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphPath;
import eu.javaexperience.graph.GraphVertexTransition;

public class GraphSearchVertexTransition<V, E>
extends GraphVertexTransition<GraphPath<V, E>, V, E> {
    protected GraphSearchVertexTransition<V, E> prev;
    protected GraphSearchVertexTransition<V, E> next;
    protected transient int hashCode = 0;

    protected GraphSearchVertexTransition(GraphPath<V, E> path, V from, E edge, V to) {
        super(path, from, edge, to);
    }

    public GraphSearchVertexTransition<V, E> addVertexForward(E e, V next) {
        if (this.isInitial()) {
            this.edge = e;
            this.to = next;
            return this;
        }
        GraphSearchVertexTransition<Object, E> ret = new GraphSearchVertexTransition<Object, E>((GraphPath)this.owner, this.to, e, next);
        ret.prev = this;
        this.next = ret;
        ((GraphPath)this.owner).registerLast(ret);
        return ret;
    }

    public GraphSearchVertexTransition<V, E> addVertexBackward(V prev, E e) {
        if (this.isInitial()) {
            this.edge = e;
            this.from = prev;
            return this;
        }
        GraphSearchVertexTransition<Object, E> ret = new GraphSearchVertexTransition<Object, E>((GraphPath)this.owner, prev, e, this.from);
        ret.next = this;
        this.prev = ret;
        ((GraphPath)this.owner).registerFirst(ret);
        return ret;
    }

    public GraphSearchVertexTransition<V, E> prev() {
        return this.prev;
    }

    public GraphSearchVertexTransition<V, E> next() {
        return this.next;
    }

    public boolean isInitial() {
        return null == this.edge;
    }

    void setOwner(GraphPath<V, E> owner) {
        this.owner = owner;
    }

    @Override
    public int hashCode() {
        if (0 != this.hashCode) {
            return this.hashCode;
        }
        int ret = 27;
        if (null != this.from) {
            ret = 31 * ret + this.from.hashCode();
        }
        if (null != this.edge) {
            ret = 31 * ret + this.edge.hashCode();
        }
        if (null != this.to) {
            ret = 31 * ret + this.to.hashCode();
        }
        this.hashCode = ret;
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphSearchVertexTransition)) {
            return false;
        }
        GraphSearchVertexTransition other = (GraphSearchVertexTransition)obj;
        return this.from.equals(other.from) && (this.edge == other.edge || this.edge.equals(other.edge)) && this.to.equals(other.to);
    }
}

