/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.binary;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.util.Arrays;

public class FramedPacketCutter {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("FramedPacketReader"));
    protected byte packetEscape;
    protected SimplePublish1<byte[]> packet;
    byte[] buffer = new byte[1024];
    boolean mayCut = false;
    int ep = 0;

    public FramedPacketCutter(byte escapeByte, SimplePublish1<byte[]> packet) {
        this.packetEscape = escapeByte;
        this.packet = packet;
    }

    public void clear() {
        this.ep = 0;
    }

    public synchronized void feedBytes(byte[] data, int length) {
        boolean trace = LOG.mayLog(LogLevel.TRACE);
        for (int i = 0; i < length; ++i) {
            byte b = data[i];
            if (trace) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.TRACE, "Feeding byte: %s, mayCut: %s, ep: %s, ", 0xFF & b, this.mayCut, this.ep, Arrays.toString(Arrays.copyOf(this.buffer, this.ep)));
            }
            if (this.mayCut) {
                if (b == this.packetEscape) {
                    this.buffer[this.ep++] = this.packetEscape;
                } else {
                    int cut = this.ep;
                    this.ep = 0;
                    this.packet.publish(Arrays.copyOf(this.buffer, cut));
                }
                this.mayCut = false;
            } else if (b == this.packetEscape) {
                this.mayCut = true;
            } else {
                this.buffer[this.ep++] = b;
            }
            if (this.ep != this.buffer.length) continue;
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
    }
}

