/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.list;

import eu.javaexperience.collection.ImprovedCollection;
import eu.javaexperience.collection.iterator.IteratorTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RWArrayList<E>
implements List<E>,
ImprovedCollection<E> {
    protected ArrayList<E> list = new ArrayList();
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected ReentrantReadWriteLock.ReadLock rl = this.lock.readLock();
    protected ReentrantReadWriteLock.WriteLock wl = this.lock.writeLock();

    @Override
    public int size() {
        this.rl.lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.rl.lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.rl.lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.rl.lock();
        try {
            Iterator<Object> iterator = IteratorTools.wrapArray(this.list.toArray());
            return iterator;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.rl.lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.rl.lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.wl.lock();
        try {
            boolean bl = this.list.add(e);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.wl.lock();
        try {
            boolean bl = this.list.remove(o);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.rl.lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.wl.lock();
        try {
            boolean bl = this.list.addAll(c);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.wl.lock();
        try {
            boolean bl = this.list.addAll(index, c);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.wl.lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.wl.lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public void clear() {
        this.wl.lock();
        try {
            this.list.clear();
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public E get(int index) {
        this.rl.lock();
        try {
            E e = this.list.get(index);
            return e;
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.wl.lock();
        try {
            E e = this.list.set(index, element);
            return e;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        this.wl.lock();
        try {
            this.list.add(index, element);
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public E remove(int index) {
        this.wl.lock();
        try {
            E e = this.list.remove(index);
            return e;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.rl.lock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.rl.lock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        this.wl.lock();
        try {
            ListIterator listIterator = ((ArrayList)this.list.clone()).listIterator();
            return listIterator;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.wl.lock();
        try {
            ListIterator listIterator = ((ArrayList)this.list.clone()).listIterator(index);
            return listIterator;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.rl.lock();
        try {
            List<E> list = this.list.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyAll(Collection<? super E> dst) {
        this.rl.lock();
        try {
            int ret = 0;
            for (E e : this.list) {
                if (!dst.add(e)) continue;
                ++ret;
            }
            int n = ret;
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Deprecated
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.rl;
    }

    @Deprecated
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.wl;
    }

    @Deprecated
    public List<E> getBackendList() {
        return this.list;
    }
}

