/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.set.ArrayListSeemsSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class BulkTransitMap<K, V>
implements Map<K, V>,
Cloneable {
    protected ArrayListSeemsSet<Map.Entry<K, V>> records = new ArrayListSeemsSet();

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            for (Map.Entry entry : this.records) {
                if (entry.getKey() != null) continue;
                return true;
            }
        } else {
            for (Map.Entry entry : this.records) {
                if (!key.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (Map.Entry entry : this.records) {
                if (entry.getValue() != null) continue;
                return true;
            }
        } else {
            for (Map.Entry entry : this.records) {
                if (!value.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            for (Map.Entry entry : this.records) {
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        } else {
            for (Map.Entry entry : this.records) {
                if (!key.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.records.add(new KeyVal<K, V>(key, value));
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            for (Map.Entry entry : this.records) {
                if (entry.getKey() != null) continue;
                Object ret = entry.getValue();
                this.records.remove(entry);
                return ret;
            }
        } else {
            for (Map.Entry entry : this.records) {
                if (!key.equals(entry.getKey())) continue;
                Object ret = entry.getValue();
                this.records.remove(entry);
                return ret;
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> kv : m.entrySet()) {
            this.records.add(new KeyVal<K, V>(kv.getKey(), kv.getValue()));
        }
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public Set<K> keySet() {
        ArrayListSeemsSet keys = new ArrayListSeemsSet();
        for (Map.Entry entry : this.records) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList vals = new ArrayList();
        for (Map.Entry entry : this.records) {
            vals.add(entry.getValue());
        }
        return vals;
    }

    @Override
    public ArrayListSeemsSet<Map.Entry<K, V>> entrySet() {
        return this.records;
    }

    public String toString() {
        return MapTools.toStringMultiline(this);
    }

    public BulkTransitMap<K, V> clone() {
        BulkTransitMap<K, V> ret = new BulkTransitMap<K, V>();
        ret.records.addAll(this.records);
        return ret;
    }
}

