/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.AbstractMap;
import eu.javaexperience.collection.map.ChainedMap;
import eu.javaexperience.collection.map.SmallMap;
import java.util.Map;
import java.util.Set;

public class TransactionMap<K, V>
extends AbstractMap<K, V> {
    protected Map<K, V> modifiable;
    protected Map<K, V> diff;
    protected Map<K, Boolean> contains;
    protected Map<K, V> access;
    protected Map<K, V> origin;
    public static final Object NULL_VALUE = new Object();

    public TransactionMap(Map<K, V> origin) {
        this.origin = origin;
        this.diff = new SmallMap();
        this.access = new SmallMap();
        this.contains = new SmallMap<K, Boolean>();
        this.modifiable = new ChainedMap(this.diff, this.access, origin);
    }

    public Map<K, V> getOriginalMap() {
        return this.origin;
    }

    public Map<K, V> getAccessMap() {
        return this.access;
    }

    public Map<K, V> getDiffMap() {
        return this.diff;
    }

    public Map<K, V> getModifiableMap() {
        return this.modifiable;
    }

    protected V touchValue(K key) {
        V in = this.access.get(key);
        if (null != in) {
            in = this.modifiable.get(key);
            if (NULL_VALUE == in) {
                return null;
            }
            return in;
        }
        V re = this.origin.get(key);
        if (null == re) {
            this.access.put(key, NULL_VALUE);
            return null;
        }
        this.access.put(key, re);
        return re;
    }

    @Override
    public boolean containsKey(Object key) {
        return null != this.touchValue(key);
    }

    @Override
    public V get(Object key) {
        return this.touchValue(key);
    }

    @Override
    public V put(K key, V value) {
        V o = this.touchValue(key);
        this.modifiable.put(key, value);
        return o;
    }

    @Override
    public V remove(Object key) {
        V o = this.touchValue(key);
        this.modifiable.put(key, NULL_VALUE);
        return o;
    }

    @Override
    public void clear() {
        for (K k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public Set<K> keySet() {
        Set<K> ret = this.modifiable.keySet();
        for (K k : ret) {
            this.touchValue(k);
        }
        return ret;
    }

    public V getAccessTimeValue(K key) {
        V in = this.access.get(key);
        if (NULL_VALUE == in) {
            return null;
        }
        return in;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Object v : this.values()) {
            if (null == v) continue;
            ++ret;
        }
        return ret;
    }
}

