/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.database.ConnectionBuilder;
import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.ConnectionPool;
import eu.javaexperience.database.JdbcIssuedConnection;
import eu.javaexperience.database.failsafe.JdbcFailSafeConnection;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class JdbcConnectionPool
implements ConnectionPool {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("JdbcConnectionPool"));
    protected ConnectionCreator cc;
    private final ArrayList<ConnectionData> pool = new ArrayList();

    public JdbcConnectionPool(ConnectionCreator cc) {
        this.cc = cc;
    }

    public JdbcConnectionPool(ConnectionBuilder type, String host, int port, String user, String passwd, String db) {
        this.cc = ConnectionCreator.fromConnectionBuilder(type, host, port, user, passwd, db);
    }

    public JdbcConnectionPool(ConnectionBuilder type, String user, String passwd, String db) {
        this(type, null, -1, user, passwd, db);
    }

    public JdbcConnectionPool(ConnectionBuilder type, String host, String user, String passwd, String db) {
        this(type, host, -1, user, passwd, db);
        AssertArgument.assertNotNull(host, "host");
    }

    @Override
    public synchronized JdbcIssuedConnection getConnection() throws SQLException {
        for (ConnectionData d : this.pool) {
            if (!d.check()) continue;
            LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Issue existing connection: %s", (Object)d.conn);
            return new JdbcIssuedConnection(d);
        }
        ConnectionData ret = new ConnectionData(this.openNewConnection());
        this.pool.add(ret);
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Issue new connection: %s", (Object)ret.conn);
        return new JdbcIssuedConnection(ret);
    }

    protected Connection openNewConnection() throws SQLException {
        return new JdbcFailSafeConnection(this.cc, 3);
    }

    public class ConnectionData {
        boolean free = true;
        Connection conn;
        long lastGet = System.currentTimeMillis();

        public ConnectionData(Connection conn) {
            this.conn = conn;
        }

        boolean check() throws SQLException {
            return this.free;
        }

        public boolean isFree() {
            return this.free;
        }

        public long getLastGet() {
            return this.lastGet;
        }
    }
}

