/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database;

import eu.javaexperience.database.JdbcConnectionPool;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.io.Closeable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JdbcIssuedConnection
implements Closeable,
AutoCloseable,
Connection {
    protected final Connection origin;
    protected final JdbcConnectionPool.ConnectionData data;
    protected boolean closed = false;

    protected Connection getOrigin() {
        return this.origin;
    }

    public JdbcIssuedConnection(JdbcConnectionPool.ConnectionData c) {
        if (!c.free) {
            throw new RuntimeException("Kiadott kapcsolat \u00fajra ki lett adva");
        }
        c.lastGet = System.currentTimeMillis();
        c.free = false;
        this.data = c;
        this.origin = this.data.conn;
    }

    protected void assertNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("IssuedConnection closed");
        }
    }

    @Override
    public void close() {
        LoggingTools.tryLogFormat(JdbcConnectionPool.LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Close issued connection: %s", (Object)this.origin);
        this.closed = true;
        this.data.free = true;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.unwrap(arg0);
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.abort(arg0);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertNotClosed();
        this.origin.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.assertNotClosed();
        this.origin.commit();
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.createArrayOf(arg0, arg1);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.assertNotClosed();
        return this.origin.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.assertNotClosed();
        return this.origin.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.assertNotClosed();
        return this.origin.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.assertNotClosed();
        return this.origin.createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertNotClosed();
        return this.origin.createStatement();
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.createStatement(arg0, arg1);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        this.assertNotClosed();
        return this.origin.createStatement(arg0, arg1);
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.createStruct(arg0, arg1);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertNotClosed();
        return this.origin.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertNotClosed();
        return this.origin.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.assertNotClosed();
        return this.origin.getClientInfo();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.getClientInfo(arg0);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertNotClosed();
        return this.origin.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertNotClosed();
        return this.origin.getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.assertNotClosed();
        return this.origin.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        this.assertNotClosed();
        return this.origin.getSchema();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertNotClosed();
        return this.origin.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.assertNotClosed();
        return this.origin.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertNotClosed();
        return this.origin.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertNotClosed();
        return this.origin.isReadOnly();
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.isValid(arg0);
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.nativeSQL(arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareCall(arg0);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareCall(arg0, arg1, arg2);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareCall(arg0, arg1, arg2, arg3);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0, arg1);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0, arg1);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0, arg1);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0, arg1, arg2);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertNotClosed();
        return this.origin.prepareStatement(arg0, arg1, arg2, arg3);
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.releaseSavepoint(arg0);
    }

    @Override
    public void rollback() throws SQLException {
        this.assertNotClosed();
        this.origin.rollback();
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.rollback(arg0);
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setAutoCommit(arg0);
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setCatalog(arg0);
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        this.origin.setClientInfo(arg0);
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException();
        }
        this.origin.setClientInfo(arg0, arg1);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setHoldability(arg0);
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        this.assertNotClosed();
        this.origin.setNetworkTimeout(arg0, arg1);
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setReadOnly(arg0);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.assertNotClosed();
        return this.origin.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        this.assertNotClosed();
        return this.origin.setSavepoint(arg0);
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setSchema(arg0);
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setTransactionIsolation(arg0);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        this.assertNotClosed();
        this.origin.setTypeMap(arg0);
    }
}

