/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.file.fs.zip;

import eu.javaexperience.collection.tree.TreeNode;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.AbstractFileSystem;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.file.fs.zip.ZipFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.zip.ZipEntry;

public class ZipFsFile
implements AbstractFile {
    protected ZipFileSystem fs;
    protected String file;
    protected ZipEntry ent;

    public ZipFsFile(ZipFileSystem fs, String file) {
        this.fs = fs;
        this.file = file;
        TreeNode tn = fs.getNodeByPath(file);
        if (null != tn) {
            this.ent = (ZipEntry)tn.getEtc("ent");
        }
    }

    @Override
    public String getUrl() {
        return this.file;
    }

    @Override
    public String getFileName() {
        String[] p = FileSystemTools.decomposePath(this.file);
        if (0 == p.length) {
            return "";
        }
        return p[p.length - 1];
    }

    @Override
    public AbstractFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public AbstractFile getCanonicalFile() throws IOException {
        if (null == this.ent) {
            return null;
        }
        return this;
    }

    @Override
    public boolean delete() throws IOException {
        return false;
    }

    @Override
    public long lastModified() {
        if (null == this.ent) {
            return 0L;
        }
        return this.ent.getLastModifiedTime().toMillis();
    }

    @Override
    public boolean setLastModified(long time) throws IOException {
        if (null == this.ent) {
            return false;
        }
        this.ent.setLastModifiedTime(FileTime.fromMillis(time));
        return true;
    }

    @Override
    public boolean exists() {
        return null != this.ent;
    }

    @Override
    public boolean createNewRegularFile() throws IOException {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        if (null == this.ent) {
            return false;
        }
        return !this.ent.isDirectory();
    }

    @Override
    public long getSize() {
        if (this.ent == null) {
            return 0L;
        }
        return this.ent.getSize();
    }

    @Override
    public boolean isDirectory() {
        if (null == this.ent) {
            return false;
        }
        TreeNode tn = this.fs.getNodeByPath(this.file);
        if (null != tn && !tn.getChilds().isEmpty()) {
            return true;
        }
        return this.ent.isDirectory();
    }

    @Override
    public AbstractFile[] listFiles() {
        if (null == this.ent) {
            return null;
        }
        TreeNode tn = this.fs.getNodeByPath(this.file);
        if (null == tn) {
            return null;
        }
        List chs = tn.getChilds();
        AbstractFile[] ret = new AbstractFile[chs.size()];
        for (int i = 0; i < chs.size(); ++i) {
            TreeNode ch = (TreeNode)chs.get(i);
            ret[i] = new ZipFsFile(this.fs, this.fs.toPath(ch));
        }
        return ret;
    }

    @Override
    public boolean mkdir() throws IOException {
        return false;
    }

    @Override
    public boolean mkdirs() throws IOException {
        return false;
    }

    @Override
    public boolean canRead() {
        return null != this.ent;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    public void assertExists() throws IOException {
        if (null == this.ent) {
            throw new IOException("File `" + this.file + "` in zip `" + this.fs.file + "` doesn't exists.");
        }
    }

    @Override
    public InputStream openRead() throws IOException {
        this.assertExists();
        return this.fs.zip.getInputStream(this.ent);
    }

    @Override
    public OutputStream openWrite(boolean append) throws IOException {
        throw new IOException("Zip archive is not writeable `" + this.file + "` in zip `" + this.fs.file + "`");
    }

    @Override
    public AbstractFile getParentFile() {
        TreeNode tn = this.fs.getNodeByPath(this.file);
        if (null == tn) {
            return null;
        }
        if (null == (tn = tn.getParent())) {
            return null;
        }
        return new ZipFsFile(this.fs, this.fs.toPath(tn));
    }

    public String toString() {
        return "FipFsFile: `" + this.file + "` in `" + this.fs.file + "`";
    }
}

