/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.io.FileContentMapper;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DirectoryContentBasedMap<T>
implements Map<String, T>,
Closeable {
    protected File dir;
    protected OutputStream keyFd;
    protected Map<String, Integer> keyIndex = new HashMap<String, Integer>();
    protected ArrayList<String> keyStore = new ArrayList();

    public DirectoryContentBasedMap(File directory) throws FileNotFoundException {
        if (!directory.isDirectory()) {
            throw new RuntimeException("file: \"" + directory + "\" must be directory");
        }
        this.dir = directory;
        this.populateKeys();
        File kf = this.getKeyFile();
        this.keyFd = kf.exists() ? new FileOutputStream(this.getKeyFile(), true) : new FileOutputStream(this.getKeyFile());
    }

    protected abstract T readValue(File var1, int var2);

    protected File getKeyFile() {
        return new File(this.dir + "/keys");
    }

    protected void populateKeys() {
        File keys = this.getKeyFile();
        if (keys.exists()) {
            try (FileInputStream fis = new FileInputStream(keys);
                 InputStreamReader isr = new InputStreamReader(fis);
                 BufferedReader br = new BufferedReader(isr);){
                String line = null;
                int i = 0;
                while (null != (line = br.readLine())) {
                    line = URLDecoder.decode(line, "UTF-8");
                    this.keyStore.add(line);
                    this.keyIndex.put(line, i++);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected int assertKey(String key) {
        if (null == key) {
            return -1;
        }
        int index = this.getKeyIndex(key);
        if (index > -1) {
            return index;
        }
        try {
            this.keyFd.write((URLEncoder.encode(key, "UTF-8") + "\n").getBytes());
            this.keyFd.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.keyStore.add(key);
        index = this.keyStore.size() - 1;
        this.keyIndex.put(key, index);
        return index;
    }

    protected void clearKeys() {
        this.keyStore.clear();
        this.keyIndex.clear();
        try {
            this.keyFd.close();
            File keyFile = this.getKeyFile();
            keyFile.delete();
            this.keyFd = new FileOutputStream(keyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected File getDestinationFile(int index) {
        return new File(this.dir + "/" + index);
    }

    protected void dropValue(int index) {
        this.getDestinationFile(index).delete();
    }

    protected boolean isValueSet(int index) {
        return this.getDestinationFile(index).exists();
    }

    protected int getKeyIndex(Object Tey) {
        Integer ret = this.keyIndex.get(Tey);
        if (null == ret) {
            return -1;
        }
        return ret;
    }

    @Override
    public int size() {
        return this.keyIndex.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyIndex.isEmpty();
    }

    @Override
    public boolean containsKey(Object Tey) {
        int index = this.getKeyIndex(Tey);
        if (index < 0) {
            return false;
        }
        return this.isValueSet(index);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public synchronized T get(Object Tey) {
        int index = this.getKeyIndex(Tey);
        if (index > -1) {
            return this.readValue(this.getDestinationFile(index), index);
        }
        return null;
    }

    protected abstract void saveValue(File var1, int var2, T var3);

    @Override
    public synchronized T put(String Tey, T value) {
        int index = this.assertKey(Tey);
        if (index > -1) {
            this.saveValue(this.getDestinationFile(index), index, value);
        }
        return null;
    }

    @Override
    public synchronized T remove(Object Tey) {
        int index = this.getKeyIndex(Tey);
        if (index > -1) {
            this.dropValue(index);
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> Tv : m.entrySet()) {
            this.put(Tv.getKey(), Tv.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < this.keyStore.size(); ++i) {
            this.dropValue(i);
        }
        this.clearKeys();
    }

    @Override
    public synchronized Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.keyStore);
        return ret;
    }

    @Override
    public synchronized Collection<T> values() {
        ArrayList<T> ret = new ArrayList<T>();
        for (int i = 0; i < this.keyStore.size(); ++i) {
            T add = this.readValue(this.getDestinationFile(i), i);
            if (null == add) continue;
            ret.add(add);
        }
        return ret;
    }

    @Override
    public synchronized Set<Map.Entry<String, T>> entrySet() {
        HashSet<Map.Entry<String, T>> ret = new HashSet<Map.Entry<String, T>>();
        for (int i = 0; i < this.keyStore.size(); ++i) {
            if (!this.isValueSet(i)) continue;
            ret.add(new LazyKV(i));
        }
        return ret;
    }

    public static <T extends Serializable> FileContentMapper<T> openWithCreate(String file) throws FileNotFoundException {
        File dir = new File(file);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new FileContentMapper(dir);
    }

    public static <T extends Serializable> FileContentMapper<T> openWithCreateRuntimeException(String file) {
        try {
            return DirectoryContentBasedMap.openWithCreate(file);
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
            return null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.keyFd.close();
    }

    protected void finalize() throws Throwable {
        IOTools.silentClose(this);
        super.finalize();
    }

    public synchronized long getValueLastModify(String key) {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return 0L;
        }
        File dst = this.getDestinationFile(index);
        if (null == dst || !dst.exists()) {
            return 0L;
        }
        return dst.lastModified();
    }

    public class LazyKV
    implements Map.Entry<String, T> {
        int index;

        protected LazyKV(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return DirectoryContentBasedMap.this.keyStore.get(this.index);
        }

        @Override
        public T getValue() {
            return DirectoryContentBasedMap.this.readValue(DirectoryContentBasedMap.this.getDestinationFile(this.index), this.index);
        }

        @Override
        public T setValue(T value) {
            DirectoryContentBasedMap.this.saveValue(DirectoryContentBasedMap.this.getDestinationFile(this.index), this.index, value);
            return null;
        }

        public int getEntryIndex() {
            return this.index;
        }
    }
}

