/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.SwappableInputStream;
import eu.javaexperience.reflect.Mirror;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FifoStream {
    protected BlockingQueue<byte[]> data;
    protected OutputStream os = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            FifoStream.this.data.add(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            FifoStream.this.data.add(Arrays.copyOfRange(b, off, off + len));
        }

        @Override
        public void write(byte[] b) throws IOException {
            FifoStream.this.data.add(Arrays.copyOf(b, b.length));
        }
    };
    protected InputStream is = new InputStream(){
        SwappableInputStream sis = new SwappableInputStream();
        {
            this.sis.is = IOTools.nullInputStream;
        }

        protected int doProperRead(byte[] dst, int off, int len) throws IOException {
            int ret = this.sis.read();
            while (ret < 0) {
                try {
                    this.sis.setInputStream(new ByteArrayInputStream(FifoStream.this.get()));
                }
                catch (InterruptedException e) {
                    Mirror.propagateAnyway(e);
                }
                if (null == dst) {
                    ret = this.sis.read();
                    continue;
                }
                if (off < 0) {
                    ret = this.sis.read(dst);
                    continue;
                }
                ret = this.sis.read(dst, off, len);
            }
            return ret;
        }

        @Override
        public int read() throws IOException {
            return this.doProperRead(null, -1, -1);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.doProperRead(b, -1, -1);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.doProperRead(b, off, len);
        }
    };

    public FifoStream(int cap) {
        this.data = new LinkedBlockingQueue<byte[]>(cap);
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public byte[] get() throws InterruptedException {
        return this.data.take();
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void put(byte[] d) {
        this.data.add(d);
    }
}

