/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.fd;

import eu.javaexperience.io.CloseSensitiveInputStream;
import eu.javaexperience.io.CloseSensitiveOutputStream;
import eu.javaexperience.io.fd.FDIOStream;
import eu.javaexperience.io.fd.FDIOStreamServer;
import eu.javaexperience.reflect.FdMirror;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class FDIOStreamFactory {
    public static FDIOStream fromSocket(final Socket s) throws IOException {
        return new CloseRegFDIO(){
            private FileDescriptor fd;
            private boolean closed;
            {
                this.fd = FdMirror.getFileDescriptorFromSocket(s);
                this.closed = false;
            }

            @Override
            public OutputStream getOutputStream() {
                try {
                    return s.getOutputStream();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            @Override
            public InputStream getInputStream() {
                try {
                    return s.getInputStream();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            @Override
            public void close() {
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public int getFD() {
                return FdMirror.getFD(this.fd);
            }

            @Override
            public boolean isClosed() {
                return this.closed;
            }

            @Override
            public void setClosed(boolean b) {
                this.closed = b;
            }

            @Override
            public FileDescriptor getFileDescriptor() {
                return this.fd;
            }

            @Override
            public void flush() throws IOException {
                s.getOutputStream().flush();
            }

            @Override
            public String localAddress() {
                return s.getLocalAddress().toString();
            }

            @Override
            public String remoteAddress() {
                return s.getRemoteSocketAddress().toString();
            }
        };
    }

    public static FDIOStream closeOnFinalize(final FDIOStream sock) {
        return new FDIOStream(){

            @Override
            public boolean isClosed() {
                return sock.isClosed();
            }

            @Override
            public OutputStream getOutputStream() {
                return sock.getOutputStream();
            }

            @Override
            public InputStream getInputStream() {
                return sock.getInputStream();
            }

            @Override
            public void close() {
                sock.close();
            }

            @Override
            public int getFD() {
                return sock.getFD();
            }

            protected void finalize() {
                this.close();
            }

            @Override
            public FileDescriptor getFileDescriptor() {
                return sock.getFileDescriptor();
            }

            @Override
            public void flush() throws IOException {
                sock.flush();
            }

            @Override
            public String localAddress() {
                return sock.localAddress();
            }

            @Override
            public String remoteAddress() {
                return sock.remoteAddress();
            }
        };
    }

    public static FDIOStream fromFD(FileDescriptor _fd) {
        return FDIOStreamFactory.fromFD(FdMirror.getFD(_fd));
    }

    public static FDIOStream fromFD(final int _fd) {
        return new FDIOStream(){
            private final int fd;
            private final FileDescriptor ofd;
            CloseSensitiveInputStream is;
            CloseSensitiveOutputStream os;
            {
                this.fd = _fd;
                this.ofd = new FileDescriptor();
                FdMirror.setFd(this.ofd, _fd);
                this.is = new CloseSensitiveInputStream(new FileInputStream(this.ofd));
                this.os = new CloseSensitiveOutputStream(new FileOutputStream(this.ofd));
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }

            @Override
            public void close() {
                try {
                    this.os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public int getFD() {
                return this.fd;
            }

            @Override
            public boolean isClosed() {
                return this.is.isClosed() || this.os.isClosed();
            }

            @Override
            public FileDescriptor getFileDescriptor() {
                return this.ofd;
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public String localAddress() {
                return String.valueOf(this.fd);
            }

            @Override
            public String remoteAddress() {
                return String.valueOf(this.fd);
            }
        };
    }

    public static FDIOStreamServer fromServerSocket(final ServerSocket ss) {
        return new FDIOStreamServer(){

            @Override
            public void close() {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public FDIOStream accept() throws IOException {
                try {
                    return FDIOStreamFactory.fromSocket(ss.accept());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int getFD() {
                return 0;
            }

            @Override
            public FileDescriptor getFileDescriptor() {
                return null;
            }
        };
    }

    public static interface CloseRegFDIO
    extends FDIOStream {
        public void setClosed(boolean var1);
    }
}

