/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.file;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TmpFile
implements Closeable {
    protected File file;

    public TmpFile(String prefix, String postfix) throws IOException {
        this.file = FileTools.generateTempFilename(prefix, 50, postfix);
    }

    public File getFile() {
        return this.file;
    }

    public void create() throws IOException {
        this.file.createNewFile();
    }

    public FileInputStream openRead() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public PrintWriter openWriter() throws FileNotFoundException {
        return new PrintWriter(this.file);
    }

    public FileOutputStream openWrite() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    @Override
    public void close() throws IOException {
        this.file.delete();
    }

    public byte[] getFileBytes() throws IOException {
        return IOTools.loadFileContent(this.file.toString());
    }
}

