/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.log;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLogger
implements Logger {
    protected final AtomicReference<LoggingDetailLevel> currentLogLevel = new AtomicReference<LogLevel>(LogLevel.INFO);
    protected final String name;

    public AbstractLogger(LoggableUnitDescriptor descr) {
        this(descr.getUnitShortName(), descr.getDefaultLoggingLevel());
    }

    public AbstractLogger(String name, LoggingDetailLevel defaultLoglevel) {
        this.name = name;
        AssertArgument.assertNotNull(this.name, "name");
        AssertArgument.assertNotNull(defaultLoglevel, "loglevel");
        this.currentLogLevel.set(defaultLoglevel);
    }

    @Override
    public String getFacilityName() {
        return this.name;
    }

    @Override
    public void setLogLevel(LoggingDetailLevel level) {
        AssertArgument.assertNotNull(level, "loglevel");
        this.currentLogLevel.set(level);
    }

    @Override
    public LoggingDetailLevel getLogLevel() {
        return this.currentLogLevel.get();
    }

    @Override
    public boolean mayLog(LoggingDetailLevel level) {
        return level.getLevel() <= this.currentLogLevel.get().getLevel();
    }

    @Override
    public void log(LoggingDetailLevel lvl, String str) {
        try {
            this.doLog(LoggingTools.createLogLine(this, lvl, str));
        }
        catch (Exception e) {
            System.err.println("Exception while logging: ");
            e.printStackTrace();
        }
    }

    @Override
    public void logFormat(LoggingDetailLevel lvl, String formatString, Object ... params) {
        try {
            this.doLog(LoggingTools.createLogLine(this, lvl, formatString, params));
        }
        catch (Exception e) {
            System.err.println("Exception while logging: ");
            e.printStackTrace();
        }
    }

    @Override
    public void logException(LoggingDetailLevel lvl, Throwable t) {
        try {
            this.doLog(LoggingTools.createExceptionLogLine(this, lvl, t));
        }
        catch (Exception e) {
            System.err.println("Exception while logging: ");
            e.printStackTrace();
        }
    }

    protected abstract void doLog(String var1);

    @Override
    public void logExceptionFormat(LoggingDetailLevel level, Throwable t, String format, Object ... params) {
        try {
            this.doLog(LoggingTools.createFormattedExceptionLogLine(this, level, t, format, params));
        }
        catch (Exception e) {
            System.err.println("Exception while logging: ");
            e.printStackTrace();
        }
    }
}

