/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.multithread.Job;
import eu.javaexperience.multithread.notify.WaitForEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MultithreadingTools {
    public static final Error THREAD_SHUTDOWN_POISON = new Error();

    public static <E> Job<Queue<E>> processAll(final Job<E> job) {
        return new Job<Queue<E>>(){

            @Override
            public void exec(Queue<E> param) throws Throwable {
                Object elem = null;
                while (true) {
                    Object e = param.poll();
                    elem = e;
                    if (e == null) break;
                    job.exec(elem);
                }
            }
        };
    }

    public static <E> Job<BlockingQueue<E>> processInfinite(final Job<E> job) {
        return new Job<BlockingQueue<E>>(){

            @Override
            public void exec(BlockingQueue<E> param) throws Throwable {
                Object elem = null;
                while (true) {
                    Object e = param.take();
                    elem = e;
                    if (e == null) break;
                    job.exec(elem);
                }
            }
        };
    }

    public static void topLevelException(Throwable t) {
        System.err.println("=== TOP LEVEL UNCATCHED EXCEPTION");
        t.printStackTrace();
    }

    public static <T> void adhocMultiProcessAll(final Queue<T> units, int concurrency, final SimplePublish1<T> exec) {
        for (int i = 0; i < concurrency; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Object elem = null;
                    while (true) {
                        Object e = units.poll();
                        elem = e;
                        if (null == e) break;
                        exec.publish(elem);
                    }
                }
            }.start();
        }
    }

    public static <P, R> List<R> processAllConcurrently(int maxConcurrency, Collection<P> toProc, final GetBy1<R, P> processor) {
        final WaitForEvents w = new WaitForEvents(toProc.size());
        final ArrayList ret = new ArrayList();
        final LinkedBlockingQueue<P> params = new LinkedBlockingQueue<P>();
        params.addAll(toProc);
        int c = Math.min(maxConcurrency, toProc.size());
        for (int i = 0; i < c; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object p = null;
                    while (true) {
                        Object e = params.poll();
                        p = e;
                        if (null == e) return;
                        try {
                            Object proc = processor.getBy(p);
                            List list = ret;
                            synchronized (list) {
                                ret.add(proc);
                                continue;
                            }
                        }
                        catch (Throwable t) {
                            MultithreadingTools.topLevelException(t);
                            continue;
                        }
                        finally {
                            w.call();
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
        w.waitForAllEvent();
        return ret;
    }
}

