/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithreading.pools;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.multithread.MultithreadingTools;
import java.util.LinkedList;

public class TimeoutJobPool {
    protected final Object wakeTimeout = new Object();
    protected LinkedList<TimeoutJob> timeoutJobs = new LinkedList();
    protected Thread timeoutWorker = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (true) {
                        TimeoutJob j;
                        long w;
                        if ((w = TimeoutJobPool.this.getNextEventTime() - System.currentTimeMillis()) > 0L) {
                            Object object = TimeoutJobPool.this.wakeTimeout;
                            synchronized (object) {
                                TimeoutJobPool.this.wakeTimeout.wait(w);
                            }
                        }
                        if ((j = TimeoutJobPool.this.getNextJobOrNull()) == null) continue;
                        try {
                            j.ac.call();
                            continue block7;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    if (t == MultithreadingTools.THREAD_SHUTDOWN_POISON) {
                        return;
                    }
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };

    public TimeoutJobPool() {
        this.timeoutWorker.setDaemon(true);
        this.timeoutWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextEventTime() {
        LinkedList<TimeoutJob> linkedList = this.timeoutJobs;
        synchronized (linkedList) {
            long max = Long.MAX_VALUE;
            for (TimeoutJob t : this.timeoutJobs) {
                if (t.onTime >= max) continue;
                max = t.onTime;
            }
            return max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeoutJob getNextJobOrNull() {
        LinkedList<TimeoutJob> linkedList = this.timeoutJobs;
        synchronized (linkedList) {
            long t0 = System.currentTimeMillis();
            for (int i = 0; i < this.timeoutJobs.size(); ++i) {
                TimeoutJob t = this.timeoutJobs.get(i);
                if (t.onTime > t0) continue;
                this.timeoutJobs.remove(i);
                return t;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTimoutJob(int timeout, SimpleCall ac) {
        if (timeout >= 0 && ac != null) {
            LinkedList<TimeoutJob> linkedList = this.timeoutJobs;
            synchronized (linkedList) {
                this.timeoutJobs.add(new TimeoutJob(timeout, ac));
                Object object = this.wakeTimeout;
                synchronized (object) {
                    this.wakeTimeout.notifyAll();
                }
            }
        }
    }

    protected static class TimeoutJob {
        long onTime;
        SimpleCall ac;

        public TimeoutJob(int dt, SimpleCall ac) {
            this.onTime = System.currentTimeMillis() + (long)dt;
            this.ac = ac;
        }
    }
}

