/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.behavioral.cor;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.RWLockMap;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.patterns.behavioral.cor.CorChain;
import java.util.LinkedHashMap;
import java.util.Map;

public class CorDispatcher<CTX>
implements Dispatcher<CTX> {
    protected Map<String, CorChain<CTX>> chains = new RWLockMap<String, CorChain<CTX>>(new LinkedHashMap());
    protected CorChain<CTX> root_chain;

    public void setRootChain(CorChain<CTX> root) {
        AssertArgument.assertNotNull(root, "root");
        this.root_chain = root;
    }

    public CorChain<CTX> addChain(CorChain<CTX> chain) {
        return this.chains.put(chain.getChainName(), chain);
    }

    public CorChain<CTX> getChainByName(String name) {
        return this.chains.get(name);
    }

    @Override
    public boolean dispatch(CTX ctx) {
        if (null == this.root_chain) {
            if (!this.chains.isEmpty()) {
                for (CorChain<CTX> c : this.chains.values()) {
                    if (!c.dispatch(ctx)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.root_chain.dispatch(ctx);
    }
}

