/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.creational.builder;

import eu.javaexperience.patterns.creational.builder.PublisherBuilder;

public class PublisherBuilderTools {
    public static <R, P, I> R buildAll(PublisherBuilder<P, R, I> builder, I init, Iterable<P> params) {
        builder.initialize(init);
        for (P p : params) {
            builder.publish(p);
        }
        return builder.getResult();
    }

    public static <R, P, I> R buildAll(PublisherBuilder<P, R, I> builder, I init, P ... params) {
        builder.initialize(init);
        for (P p : params) {
            builder.publish(p);
        }
        return builder.getResult();
    }
}

