/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.query;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.LogicalRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LogicalGroup {
    public static LogicalGroup[] emptyLogicalGroupArray = new LogicalGroup[0];
    private final LogicalRelation lr;
    private final LogicalGroup[] components;
    private final AtomicCondition ac;

    public LogicalGroup(AtomicCondition ac) {
        this.ac = ac;
        this.components = null;
        this.lr = LogicalRelation.unit;
    }

    public LogicalGroup(LogicalRelation lr, LogicalGroup[] grp) {
        this.ac = null;
        this.components = grp;
        this.lr = lr;
    }

    public LogicalRelation getLogicalRelation() {
        return this.lr;
    }

    public AtomicCondition getAtomicCondition() {
        return this.ac;
    }

    public LogicalGroup[] getLogicalGroups() {
        return this.components;
    }

    public String toString() {
        if (null != this.ac) {
            return this.ac.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (LogicalGroup c : this.components) {
            if (sb.length() > 0) {
                sb.append(" ");
                sb.append(this.lr.name());
                sb.append(" ");
            }
            sb.append(c.toString());
        }
        return sb.toString();
    }

    public static LogicalGroup parse(Map<String, Object> obj) {
        String relation = (String)obj.get("r");
        Map atomicCondidition = (Map)obj.get("a");
        List comp = CollectionTools.tryWrapToList(obj.get("c"), "components");
        if (null != atomicCondidition) {
            return new LogicalGroup(AtomicCondition.parse(atomicCondidition));
        }
        LogicalGroup[] lrs = new LogicalGroup[comp.size()];
        for (int i = 0; i < lrs.length; ++i) {
            lrs[i] = LogicalGroup.parse((Map)comp.get(i));
        }
        return new LogicalGroup(LogicalRelation.valueOf(relation), lrs);
    }

    public void write(Map<String, Object> to) {
        to.put("r", this.lr.name());
        if (null != this.ac) {
            SmallMap<String, Object> map = new SmallMap<String, Object>();
            this.ac.write(map);
            to.put("a", map);
        } else {
            ArrayList<SmallMap<String, Object>> lst = new ArrayList<SmallMap<String, Object>>();
            for (LogicalGroup c : this.components) {
                SmallMap<String, Object> map = new SmallMap<String, Object>();
                c.write(map);
                lst.add(map);
            }
            to.put("c", lst);
        }
    }
}

